/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   ansconf.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ansconf_H
#define ansconf_H 1

#include <time.h>

#include <strtotype.h>

/* This is used internally while reading a file to
set cached_answer. */
typedef struct answer_config {
        /* The owner of the socket */
        uid_t			ac_uid;
        /* The username, if extant */
        char*			ac_username;
        /* The full path name of the user file, if applicable */
	char*			ac_file;

        c_answer_t		ac_ans_type;
        c_userid_t		ac_uid_type;
        char*			ac_ostype;
        char*			ac_charset;
        char*			ac_literal_userid;

        c_error_t		ac_err_type;
        char*			ac_custom_error;

        /* The file's mod time, ends up in cached_answer */
        time_t			ac_modified;

        /* This is only useful when the '--show-settings'
        option is used to differentiate between a compiled in
        default and a default set in the config file */
        struct {
        	uint		ans_type:1;
                uint		uid_type:1;
        	uint		err_type:1;
                uint		ostype:1;
                uint		charset:1;
                uint		custom_error:1;
                uint		literal_userid:1;
        } is_modified;
} AnswerConfig;

/* ==== function reference ==== */


/* Allocates an answer string based on the supplied answer_config.
Returns 0 on success, -1 on error.  Broken apart for simplicity. */
int
gen_answer_string(char** answer, AnswerConfig* ac);

/* The error formatting protion of gen_answer_string(). */
int
gen_error_string(char** answer, AnswerConfig* ac);

/* The userid portion of gen_answer_string(). */
int
gen_userid_string(char** answer, AnswerConfig* ac);

/* Frees memory associated with answer_config */
void
free_answer_config(AnswerConfig* ac);

/* Creates and returns a fresh answer_config* */
AnswerConfig*
new_answer_config( void );

/* NULLs the string pointers in an answer config and the
is_modified switches. */
void
clear_answer_config(AnswerConfig* ac);

/* performs a deep copy of an answer_config */
int
cp_answer_config(AnswerConfig* src, AnswerConfig* dst);

/* Reads a user's file and sets the passed AnswerConfig.
Returns 0 on success, -1 on error, +1 if the uid is unnamed. */
int
parse_userfile(AnswerConfig* ac);


#endif /* ansconf_H */
