/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   strtoErrorType.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "strtotype.h"

#include <macros.h>
#include <logutils.h>

/* Translates a string to its error type */
int
strtoErrorType( c_error_t* et, char* errstr ) {
	if( is_nil(errstr) ) {
        	carp("attempted to set error type to NULL");
                return -1;
        }
	if( strncmp(errstr, "custom=", strlen("custom=")) == 0 ) {
        	*et = ET_CUSTOM;
                return 0;
        }

        if( strings_eq(errstr, "unknown") )
        	*et = ET_UNKNOWN;
	else if( strings_eq(errstr, "hidden") )
            	*et = ET_HIDDEN;
        else if( strings_eq(errstr, "inval") )
        	*et = ET_INVAL;
        else if( strings_eq(errstr, "no-user") )
        	*et = ET_NOUSER;
        else if( strings_eq(errstr, "actual") )
        	*et = ET_ACTUAL;
	else {
        	carp("Unknown error type: %s", errstr);
            	return -1;
        }

        return 0;
} /* -- end strtoerrortype() -- */


/* -- end strtoErrorType.c -- */
