/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   runas_gid.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This test checks the default_runas_gid/gid in "defaults.h"            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <strtotype.h>
#define NEED_DEFAULTS
#include <defaults.h>
#undef NEED_DEFAULTS
#include <logutils.h>
#include <state.h>

int
main( void ) {
	gid_t gid;
        struct state_info state;
        state.initting = TRUE;
	if( strtogidt(&gid, default_runas_gid) ) {
        	println("Cannot set default_runas_gid");
        	exit(1);
        }

        if( ! gid ) {
        	println("Cannot set default_runas_gid to root!!");
                exit(1);
        }

	exit(0);
}

/* -- end runas_gid.c -- */
