/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   strtotype.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


/* This file defines the prototypes for the tests that
check the validity of "defaults.h".  It is run as early
as possible in the make process using the internals of
the final executable.  If any of the tests fail,
"defaults.h" must be edited and the whole program
must be remade. */


#ifndef strtotype_H
#define strtotype_H 1

#include <unistd.h>
#include <sys/types.h>


enum ANSWER_TYPE {
	AT_USERID	= 0,
#define AT_USERID	AT_USERID
        AT_ERROR	= 1
#define AT_ERROR	AT_ERROR
};
typedef uint c_answer_t;

enum USERID_TYPE {
	UT_UID		= 0,
#define UT_UID		UT_UID
	UT_NAME		= 1,
#define UT_NAME		UT_NAME
	UT_LITERAL	= 2
#define UT_LITERAL	UT_LITERAL
};
typedef uint c_userid_t;

enum ERROR_TYPE {
	ET_ACTUAL	= 0,
#define ET_ACTUAL	ET_ACTUAL
	ET_NOUSER,
#define ET_NOUSER	ET_NOUSER
	ET_HIDDEN,
#define ET_HIDDEN	ET_HIDDEN
	ET_INVAL,
#define ET_INVAL	ET_INVAL
	ET_UNKNOWN,
#define ET_UNKNOWN	ET_UNKNOWN
	ET_CUSTOM
#define ET_CUSTOM	ET_CUSTOM
};
typedef uint c_error_t;


/* Translates a string to a uid.  0 on success, -1 on error */
int
strtouidt(uid_t* uid, char* cp_uid);

/* Mallocates sets a char* to a username for a given uid;
returns 0 on success (if the username could not be found
the char* is null), -1 on error (non-extant username is not
an error). */
int
get_usernam_r(char** cp_uid, uid_t uid);

/* Gets a uid given a usernam.  Threadsafe and all that.
Returns 0 on success, -1 on error, +1 if not found */
int
get_uid_r(uid_t* uid, char* cp_uid);

/* Translates a string to the corresponding gid.  0 on success, -1 on error */
int
strtogidt(gid_t* gid, char* cp_gid);

/* Translates a string to a port number.  0 on success, -1 on error. */
int
strtoport(uint* ui_port, char* cp_port);

/* Translates a string to its answer type. */
int
strtoAnswerType( c_answer_t* at, char* answer_type );

/* Translates a string to its userid type */
int
strtoUseridType( c_userid_t* ut, char* userid );

/* Translates a string to its error type */
int
strtoErrorType( c_error_t* et, char* errstr );

/* Translates a string to a time_t.
Returns 0 on sucess, -1 on error. */
int
strtotime(time_t* t, char* s);

/* Translates a string to an unsigned long.
0 on success, -1 on error. */
int
strtoulong(ulong* u, char* s);

#endif /* strtotype_H */
