/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   strtoAnswerType.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "strtotype.h"

#include <macros.h>
#include <logutils.h>

/* Translates a string to it's answer type. */
int
strtoAnswerType( c_answer_t* at, char* ans_type ) {
	if( is_nil(ans_type) ) {
        	carp("No answer type given");
                return -1;
        }
        if( strcmp(ans_type, "error") == 0 ) {
        	*at = AT_ERROR;
        } else if ( strcmp(ans_type, "userid") == 0 ) {
        	*at = AT_USERID;
        } else {
        	carp("Invalid answer type \"%s\"", ans_type);
                return -1;
        }

        return 0;
} /* -- end strtoanstype() -- */


/* -- end strtoAnswerType.c -- */
