/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   serversettings.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef serversettings_H
#define serversettings_H 1

#include <fileutils.h>


extern struct key_func_pair server_daemon_setting[];

/* Sets the server settings to default values */
void
set_default_server_settings(void);

/* The loop for processing a daemon setting.
Returns +1 on a successful call to a deamon
setting function, -1 on error (either in the
loop, or from the function called), or
-1 if nothing matched */
int
deamon_setting_loop(struct file_line* cfl);

/* Processes the config file; 0 on success, -1 on error */

int
process_config_file( void );

/* Sets the uid to run as */
int
set_runas_uid(char* cp_uid);

/* Sets the gid to run as */
int
set_runas_gid(char* cp_gid);

/* Turns on debugging info */
int
set_debug( void );

/* Prevents running in the background */
int
set_nofork( void );

/* Sets the age for the cache */
int
set_cache_age(char* age);

/* Sets the user_dir.  Returns 0 on success, -1 on error. */
int
set_user_dir(char* dir);

/* Sets the logfile.  Returns 0 on success, -1 on error. */
int
set_logfile(char* file);

/* Sets the pidfile. Returns 0 on success, -1 on error. */
int
set_pidfile(char* file);

/* Sets the config file */
int
set_configfile(char* file);


#endif /* serversettings_H */
