/* Main.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttMain;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JFrame;
import javax.swing.JMenuBar;

import jtttGameArea.GameArea;
import jtttGameState.Buttons.QuickButtons;
import jtttMenus.FileMenu;
import jtttMenus.GameMenu;
import jtttMenus.HelpMenu;
import jtttMenus.OptionsMenu;

/** Orchestrates the Entire Mess (TM) */
// TODO: add ChatState and related framework
public class Jttt {
	public String toString() {
		return "Jttt";
	}
	
	/** singleton reference of the whole shebang. */
	protected static JFrame mainFrame = null;
	
	/** program starts here */
	public static void main( String[] args ){
		mainFrame = new JFrame("Tic Tac Toe");
		mainLayout(mainFrame.getContentPane());
		mainFrame.setJMenuBar(newMainMenu());
		mainFrame.pack();
		mainFrame.setVisible(true);
	}

	/** @return the singleton instance of the whole shebang */
	public static JFrame getMainFrame() {
		return mainFrame;
	}
	
	/**
	 * Creates the main layout.
	 * Then creates the gameArea and the buttonArea.
	 * @param c The ContentPane to create the layout in.
	 */
	static void mainLayout(Container c) {
		c.setLayout(new BorderLayout());
		c.add(GameArea.getGameArea(), BorderLayout.CENTER);
		c.add(QuickButtons.getQuickButtons(), BorderLayout.SOUTH);
	}

	static JMenuBar newMainMenu() {
		JMenuBar mm = new JMenuBar();
		mm.add(new FileMenu());
		mm.add(new GameMenu());
		mm.add(new OptionsMenu());
		mm.add(new HelpMenu());
		return mm;
	}
}


/* end Main.java */
