/* GameStateListenerList.java
 * Created on Mar 15, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState;

import javax.swing.event.EventListenerList;

/**
 * This class holds a list of all objects that are interested in receiving GameStateChangeEvents.
 * NOTE: singleton class.
 */
public class GameStateListenerList extends EventListenerList {
	public String toString() {
		return "GameStateListenerList";	
	}
	protected static GameStateListenerList _gameStateListenerList = null;
	
    /**
     * Constructor.
     */
    protected GameStateListenerList() {
        super();
    }

    /**
     * @return The singleton instance of this list
     */
    public static GameStateListenerList getGameStateListenerList() {
        if (_gameStateListenerList == null)
        	_gameStateListenerList = new GameStateListenerList();
        return _gameStateListenerList;
    }

	/**
	 * @param g The GameStateListener to add to the list
	 * @throws ClassCastException if g is not a GameStateListener
	 */
	public void addGameStateListener(GameStateListener g) {
		if(g instanceof GameStateListener)
			add(GameStateListener.class, g);
		else
			throw new ClassCastException("Only GameStateListeners may be added to this list");
	}
	
	/**
	 * @param g The GameStateListener to remove from the list
	 */
	public void  removeGameStateListener(GameStateListener g) {
		remove(GameStateListener.class, g);
	}

	/**
	 * @return Array of GameStateListeners
	 */
	public GameStateListener[] getGameStateListeners() {
		return (GameStateListener[]) getListeners(GameStateListener.class);
	}

}

/* end GameStateListenerList.java */