/* GameStateListener.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState;

import java.util.EventListener;

/**
 * This interface indicates that implementing items
 * respond to changes in the game state.
 */
public interface GameStateListener
	extends EventListener
{
	
	/**
     * The implementing Action only changes it's properties (ie, setEnabled(boolean b)) in this method.
     * An implementing JButton or JMenuItem may swap out Actions in this method.
	 * @param gsce contains the new GameState as well as the object that registered for the event
	 */
	public void gameStateChanged(GameStateChangeEvent gsce);
}

/* end GameStateListener.java */
