/* GameStateChangeEvent.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState;

import java.util.EventObject;

/**
 * An EventObject subclass.  GameStateChangeEvents hold the source of the event and a
 * reference to the GameState singleton.
 */
public class GameStateChangeEvent extends EventObject {

	public GameState gameState;
	/**
	 * A GameStateChangeEvent that reteives the GameState singleton
	 */
	public GameStateChangeEvent(Object source) {
		super(source);
		gameState = GameState.getGameState();
	}
	
	/**
	 * Alternate constructor may be used for performance reasons.
	 */
	public GameStateChangeEvent(Object source, GameState gs) {
		super(source);
		gameState = gs;
	}
	
	public String toString() {
		return "GameStateChangeEvent";
	}

}

/* end GameStateChangeEvent.java */