/* GameState.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState;

/**
 * Singleton class that holds the game state.
 */
public class GameState {
	public String toString() {
		return "GameState [" + (gameInProgress?"GameInProgress -- ":"GameNotInProgress -- ") + (gamePaused?"Paused]":"NotPaused]");
	}
	
	/** Protected Singleton Constructor */
	protected GameState() {
		gameInProgress = false;
		gamePaused = false;
	}
	
	/** The singleton instance */
	protected static GameState _gameState = null;

	/**
	 * @return the GameState singleton instance
	 */
	public static GameState getGameState() {
		if (_gameState == null)
			_gameState = new GameState();
		return _gameState;
	}
	
	/**
	 * Set to true to when a game is in progress.
	 * Set to false when the game ends. 
	 */
	protected boolean gameInProgress;
	/**
	 * Set to true only if a game is in progress and and play has been suspended..
	 * Set to false when a game is in progress and play is not suspended..
	 */
	protected boolean gamePaused;

    /**
     * @return true if a game is in progress, false if a game is not in progress.
     */
    public boolean isGameInProgress() {
        return gameInProgress;
    }

    /**
     * @return true if a game is in progress and paused, false if a game is in progress
     * but not paused.
     */
    public boolean isGamePaused() {
        return gamePaused;
    }

    /**
     * Note: if this is set to false, we set "gamePaused" to false for the sake of sanity.
     * @param b Set to true upon starting a new game, false when the game has ended.
     */
    public void setGameInProgress(boolean b) {
       	gameInProgress = b;
       	if (b == false)
       		gamePaused = false;
    }

    /**
     * @param b Set to true upon pausing a game in progress, false upon
     * "Resume"ing a game in progress.  
	 * @throws UnsupportedOperationException if an attempt is made to set this state while gameInProgress == false
     */
    public void setGamePaused(boolean b) {
		if (gameInProgress == false)
			throw new UnsupportedOperationException("Cannot set gamePaused while no game is in progress!!");
       	gamePaused = b;
    }
    
}

/* end GameState.java */