/* QuickButtons.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Buttons;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.border.EtchedBorder;

import jtttGameState.Actions.OfferDrawAction;
import jtttGameState.Actions.RequestUndoAction;
import jtttGameState.Actions.ResignGameAction;

/**
 * Singleton class of the panel containing the five "quick" buttons along the
 * bottom of the game.
 */
public class QuickButtons extends Box {
	public String toString() {
		return "QuickButtons";
	}

	protected static QuickButtons quickButtons = null;
    /**
     * Creates the quick buttons
     */
    protected QuickButtons() {
		super(BoxLayout.X_AXIS);
		setBorder(new EtchedBorder(EtchedBorder.RAISED));
		add(Box.createGlue());
		add(GameFlowJButton.getGameFlowJButton());
		add(Box.createGlue());
		add(new JButton(RequestUndoAction.getRequestUndoAction()));
		add(Box.createGlue());
		add(new JButton(ResignGameAction.getResignGameAction()));
		add(Box.createGlue());
		add(new JButton(OfferDrawAction.getOfferDrawAction()));
		add(Box.createGlue());
		add(GameTerminateJButton.getGameTerminateJButton());
		add(Box.createGlue());
    }

	/** Gets the singleton instance of this class */
	public static QuickButtons getQuickButtons() {
		if (quickButtons == null)
			quickButtons = new QuickButtons();
		return quickButtons;
	}

}

/* end QuickButtons.java */
