/* GameTerminateJMenuItem.java
 * Created on Mar 15, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Buttons;

import javax.swing.JButton;

import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;
import jtttGameState.GameStateListener;
import jtttGameState.GameStateListenerList;
import jtttGameState.Actions.AbortAction;
import jtttGameState.Actions.ExitAction;

/**
 * <I>This Description Left Intentionally Blank</I>
 */
public class GameTerminateJMenuItem extends JButton implements GameStateListener {
		public String toString() {
			return "GameTerminateJMenuItem";	
		}

	/** singleton reference */
	protected static GameTerminateJMenuItem gameTerminateJMenuItem = null;
	
	/** Constructor */
	protected GameTerminateJMenuItem() {
		super();
		GameStateListenerList.getGameStateListenerList().addGameStateListener(this);
		configureFromGameState(GameState.getGameState());
	}
	
	/** returns the singleton reference of this menu item */
	public static GameTerminateJMenuItem getGameTerminateJMenuItem() {
		if (gameTerminateJMenuItem == null)
			gameTerminateJMenuItem = new GameTerminateJMenuItem();
		return gameTerminateJMenuItem;
	}
	
    /**
     * This menu item changes it's action according to the game state
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true)
			setAction(AbortAction.getAbortAction());
		else
			setAction(ExitAction.getExitAction());
    }

}




/* end GameTerminateJMenuItem.java */