/* GameTerminateJButton.java
 * Created on Mar 15, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Buttons;

import javax.swing.JButton;

import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;
import jtttGameState.GameStateListener;
import jtttGameState.GameStateListenerList;
import jtttGameState.Actions.AbortAction;
import jtttGameState.Actions.ExitAction;

/**
 * <I>This Description Left Intentionally Blank</I>
 */
public class GameTerminateJButton extends JButton implements GameStateListener {
	public String toString() {
		return "GameTerminateJButton";	
	}

	/** singleton reference */
	protected static GameTerminateJButton gameTerminateJButton = null;
	
	/** Constructor */
	protected GameTerminateJButton() {
		super();
		GameStateListenerList.getGameStateListenerList().addGameStateListener(this);
		configureFromGameState(GameState.getGameState());
	}
	
	/** Returns the singleton reference for this button */
	public static GameTerminateJButton getGameTerminateJButton() {
		if (gameTerminateJButton == null)
			gameTerminateJButton = new GameTerminateJButton();
		return gameTerminateJButton;
	}

    /**
     * Swaps out its action upon GameStateChangeEvent
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true)
			setAction(AbortAction.getAbortAction());
		else
			setAction(ExitAction.getExitAction());
    }

}




/* end GameTerminateJButton.java */