/* GameFlowJMenuItem.java
 * Created on Mar 15, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Buttons;

import javax.swing.JMenuItem;

import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;
import jtttGameState.GameStateListener;
import jtttGameState.GameStateListenerList;
import jtttGameState.Actions.NewGameAction;
import jtttGameState.Actions.PauseGameAction;
import jtttGameState.Actions.ResumeGameAction;

/**
 * <I>This Description Left Intentionally Blank</I>
 */
public class GameFlowJMenuItem extends JMenuItem implements GameStateListener {
	public String toString() {
		return "GameFlowJMenuItem";	
	}

	/** The singleton instance */
	protected static GameFlowJMenuItem gameFlowJMenuItem = null;
	
	/** Constructs the singleton */
	protected GameFlowJMenuItem() {
		super();
		GameStateListenerList.getGameStateListenerList().addGameStateListener(this);
		configureFromGameState(GameState.getGameState());
	}
	
	/**
	 * @return the singleton instance of this JButton
	 */
	public static GameFlowJMenuItem getGameFlowJMenuItem() {
		if (gameFlowJMenuItem == null)
			gameFlowJMenuItem = new GameFlowJMenuItem();
		return gameFlowJMenuItem;
	}

	/**
	 * Changes out the action of the button when the game state changes
	 */
	public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == false)
			setAction(NewGameAction.getNewGameAction());
		else {
			if (gs.isGamePaused() == true)
				setAction(ResumeGameAction.getResumeGameAction());
			else
				setAction(PauseGameAction.getPauseGameAction());
		}
	}

}

/* end GameFlowJMenuItem.java */