/* GameFlowJButton.java
 * Created on Mar 15, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Buttons;

import javax.swing.JButton;

import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;
import jtttGameState.GameStateListener;
import jtttGameState.GameStateListenerList;
import jtttGameState.Actions.NewGameAction;
import jtttGameState.Actions.PauseGameAction;
import jtttGameState.Actions.ResumeGameAction;

/**
 * This singleton has three different manifestations depending on the game state.
 * When no game is running, it is configured from "NewGameAction", when running but
 * not paused from "PauseAction" and when paused "ResumeAction".
 */
public class GameFlowJButton extends JButton implements GameStateListener {
	public String toString() {
		return "GameFlowJButton";	
	}

	/** The singleton instance */
	protected static GameFlowJButton gameFlowJButton = null;
	
	/** Constructs the singleton */
	protected GameFlowJButton() {
		super();
		GameStateListenerList.getGameStateListenerList().addGameStateListener(this);
		configureFromGameState(GameState.getGameState());
	}
	
	/**
	 * @return the singleton instance of this JButton
	 */
	public static GameFlowJButton getGameFlowJButton() {
		if (gameFlowJButton == null)
			gameFlowJButton = new GameFlowJButton();
		return gameFlowJButton;
	}

    /**
     * Changes out the action of the button when the game state changes
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == false)
			setAction(NewGameAction.getNewGameAction());
		else {
			if (gs.isGamePaused() == true)
				setAction(ResumeGameAction.getResumeGameAction());
			else
				setAction(PauseGameAction.getPauseGameAction());
		}
    }

}

/* end GameFlowJButton.java */