/* ResumeGameAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;

import java.awt.event.ActionEvent;

import jtttActions.Handlers;
import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;


public class ResumeGameAction extends GameStateAbstractAction {
	public String toString() {
		return "ResumeGameAction";
	}

	protected static ResumeGameAction resumeGameAction;

	protected ResumeGameAction() {
        super("Resume", "Resumes the paused game");
		configureFromGameState(GameState.getGameState());
    }

	/** gets the singleton reference */
	public static ResumeGameAction getResumeGameAction() {
		if (resumeGameAction == null)
			resumeGameAction = new ResumeGameAction();
		return resumeGameAction;
	}

    /** When the action is invoked, we set the game state */
    public void actionPerformed(ActionEvent ae) {
        Handlers.todo(ae.getActionCommand());
		setGamePaused(ae.getSource(), false);
    }

    /**
     * When the game is resumed, this is disabled.
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true) {
			if (gs.isGamePaused() == true)
				setEnabled(true);
			else
				setEnabled(false);
		} else
			setEnabled(false);
    }

}



/* end ResumeGameAction.java */
