/* ResignGameAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;


import java.awt.event.ActionEvent;

import jtttActions.Handlers;
import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;


public class ResignGameAction extends GameStateAbstractAction {
	public String toString() {
		return "ResignGameAction";
	}

	protected ResignGameAction() {
		super("Resign", "Resigns the current game");
		configureFromGameState(GameState.getGameState());
    }

    public void actionPerformed(ActionEvent ae) {
        Handlers.todo(ae.getActionCommand());
		setGameInProgress(ae.getSource(), false);
    }

    public static ResignGameAction getResignGameAction() {
    	if (ResignGameAction.resignGameAction == null) {
            ResignGameAction.resignGameAction = new ResignGameAction();
        }
        return ResignGameAction.resignGameAction;
    }
    static ResignGameAction resignGameAction;
    
    /**
     * When the game is paused, your ability to resign goes away.
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true) {
			if (gs.isGamePaused() == true)
				setEnabled(false);
			else
				setEnabled(true);
		} else
			setEnabled(false);
    }

}



/* end ResignGameAction.java */
