/* RequestUndoAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;

import java.awt.event.ActionEvent;

import jtttActions.Handlers;
import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;


public class RequestUndoAction extends GameStateAbstractAction {
	public String toString() {
		return "RequestUndoAction";
	}

	protected static RequestUndoAction requestUndoAction;
	
	protected RequestUndoAction() {
		super("Request Undo", "Requests that you last move be taken back");
		configureFromGameState(GameState.getGameState());
    }

	/** returns the singleton instance of this class */
	public static RequestUndoAction getRequestUndoAction() {
		if (RequestUndoAction.requestUndoAction == null) {
			RequestUndoAction.requestUndoAction = new RequestUndoAction();
		}
		return RequestUndoAction.requestUndoAction;
	}

    public void actionPerformed(ActionEvent ae) {
        Handlers.todo(ae.getActionCommand());
    }

    /**
     * Disabled when a game is not in progress or when a game is paused
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true) {
			if (gs.isGamePaused() == false)
				setEnabled(true);
			else
				setEnabled(false);
		} else // gsce.gameState.isGameInProgress() == false
			setEnabled(false);
    }

}



/* end RequestUndoAction.java */
