/* PauseGameAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;

import java.awt.event.ActionEvent;

import jtttActions.Handlers;
import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;


public class PauseGameAction extends GameStateAbstractAction {
	public String toString() {
		return "PauseGameAction";
	}

	protected static PauseGameAction pauseGameAction;

	protected PauseGameAction() {
		super("Pause", "Pauses the current game");
		configureFromGameState(GameState.getGameState());
    }

	/** returns the singleton instance of this action */
    public static PauseGameAction getPauseGameAction() {
    	if (PauseGameAction.pauseGameAction == null) {
            PauseGameAction.pauseGameAction = new PauseGameAction();
        }
        return PauseGameAction.pauseGameAction;
    }
    
	public void actionPerformed(ActionEvent ae) {
		Handlers.todo(ae.getActionCommand());
		setGamePaused(ae.getSource(), true);
	}

    /**
     * When the game is paused, this action disables itself
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGamePaused() == true)
			setEnabled(false);
		else
			setEnabled(true);
    }

}



/* end PauseGameAction.java */
