/* OfferDrawAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;

import java.awt.event.ActionEvent;

import jtttActions.Handlers;
import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;


public class OfferDrawAction extends GameStateAbstractAction {
	public String toString() {
		return "OfferDrawAction";
	}

	protected static OfferDrawAction offerDrawAction;
	
	protected OfferDrawAction() {
		super("Offer Draw", "Offers your opponant a change to save face");
		configureFromGameState(GameState.getGameState());
  }

    public static OfferDrawAction getOfferDrawAction() {
    	if (OfferDrawAction.offerDrawAction == null) {
            OfferDrawAction.offerDrawAction = new OfferDrawAction();
        }
        return OfferDrawAction.offerDrawAction;
    }
    /* (non-Javadoc)
     * @see jtttGameState.GameStateListener#gameStateChanged(jtttGameState.GameStateChangeEvent)
     */

	public void actionPerformed(ActionEvent ae) {
		Handlers.todo(ae.getActionCommand());
	}

    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true) {
			if (gs.isGamePaused() == true)
				setEnabled(false);
			else
				setEnabled(true);
		} else
			setEnabled(false);
    }

}



/* end OfferDrawAction.java */
