/* NewGameAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;

import java.awt.event.ActionEvent;

import jtttActions.Handlers;
import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;


/** Singleton class used to configure the "New Game" button and menuitem */
public class NewGameAction extends GameStateAbstractAction {
	public String toString() {
		return "NewGameAction";
	}

	protected static NewGameAction newGameAction;
	
	protected NewGameAction() {
		super("New Game", "Start a new game");
		configureFromGameState(GameState.getGameState());
    }

	/**
	 * @return The singleton reference of this action
	 */
    public static NewGameAction getNewGameAction() {
    	if (newGameAction == null) {
            newGameAction = new NewGameAction();
        }
        return newGameAction;
    }
    
	/** Sets the gameInProgress which fires a GameStateChangeEvent */
	public void actionPerformed(ActionEvent ae) {
		Handlers.todo(ae.getActionCommand());
		setGameInProgress(ae.getSource(), true);		
	}

    /**
     * Disables itself when a game is in progress
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true)
			setEnabled(false);
		else
			setEnabled(true);
    }

}

/* end NewGameAction.java */
