/* ExitAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;
import jtttMain.Jttt;


/**
 * Creates the Exit action.
 */
public class ExitAction extends GameStateAbstractAction {
	public String toString() {
		return "ExitAction";
	}

	protected static ExitAction exitAction;

    protected ExitAction() {
    	super("Exit", "Exits the Game");
    	configureFromGameState(GameState.getGameState());
    }

	/** a Window listener that exits the game when the "X" is clicked */
	protected WindowListener exitOnCloseListener = new WindowAdapter() {
		public String toString() {
			return "exitOnCloseListener";
		}
		public void windowClosing(WindowEvent we) {
			jtttExit();
		}
	};
	
    /** Does the real work of exiting.  Performs any cleanup necessary. */
    public static void jtttExit() {
        System.out.println("Exiting JTicTacToe");
        System.exit(0);
    }

    /**
     * Gets the ExitAction handler.  Creates one if necessary.
     */
    public static ExitAction getExitAction() {
    if (exitAction == null) {
            exitAction = new ExitAction();
        }
        return exitAction;
    }

    /**
	 * Disabled when a game is in progress
     */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
	}

	protected void configureFromGameState(GameState gs) {
    	if (gs.isGameInProgress() == true) {
    		setEnabled(false);
			removeExitOnCloseListeners();
     	} else {
    		setEnabled(true);
			if (isExitOnCloseListenerRegistered() == false) {
				Jttt.getMainFrame().addWindowListener(exitOnCloseListener);
			}
    	}
    }

	/** @return whether any exitOnCloseListeners are registered with the MainFrame */
	protected boolean isExitOnCloseListenerRegistered() {
		WindowListener[] listener = Jttt.getMainFrame().getWindowListeners();
		boolean found = false;
		for (int index = listener.length - 1; index >= 0; --index) {
			if (listener[index].toString() == exitOnCloseListener.toString()) {
				found = true;
				break;
			}
		}
		return found;
	}

	/** Removes any WindowListeners registered as "exitOnCloseListener" */
	protected void removeExitOnCloseListeners() {
		WindowListener[] listener = Jttt.getMainFrame().getWindowListeners();
		for (int index = listener.length - 1; index >= 0; --index) {
			if (listener[index].toString() == exitOnCloseListener.toString()) {
				Jttt.getMainFrame().removeWindowListener((WindowListener) listener[index]);
			}
		}
	}
	
	/** The required action implementation for ActionListener -- nothing more than a front end to
	jtttExit().  */
	public void actionPerformed(ActionEvent ae) {
		ExitAction.jtttExit();
	}

}


/* end ExitAction.java */
