/* AbortAction.java
 * Created on Mar 12, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameState.Actions;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import jtttGameState.GameState;
import jtttGameState.GameStateChangeEvent;
import jtttGameState.GameStateListenerList;
import jtttMain.Jttt;

/**
 * This action aborts the current game, then exits the application altogether.
 */
public class AbortAction extends GameStateAbstractAction {
	public String toString() {
		return "AbortAction";
	}
	
	/** The singleton instance of this class */
	protected static AbortAction abortAction;
	
	/** Constructor for this Action */
	protected AbortAction() {
		super("Abort", "Aborts the current game and exits");
		configureFromGameState(GameState.getGameState());
	}

	/** Window listener that aborts the game when the "X" is clicked */
	protected WindowListener abortOnCloseListener = new WindowAdapter() {
		public String toString() {
			return "abortOnCloseListener";
		}
		public void windowClosing(WindowEvent we) {
			jtttAbort();
		}
	};
	
	/**
	 * @return the singleton instance of this action
	 */
	public static AbortAction getAbortAction() {
		if (abortAction == null)
			abortAction = new AbortAction();
		return abortAction;
	}

	protected GameStateListenerList gameStateListenerList;

	/**
	 * Synchronized with gameInProgress.
	 */
    public void gameStateChanged(GameStateChangeEvent gsce) {
		configureFromGameState(gsce.gameState);
    }

	/** Sets the state according to the game state */
	protected void configureFromGameState(GameState gs) {
		if (gs.isGameInProgress() == true) {
			// if the game is in progress, register an abortOnCloseListener for the main frame
			setEnabled(true);
			if (isAbortOnCloseListenerRegistered() == false) {
				Jttt.getMainFrame().addWindowListener(abortOnCloseListener);
			}
		} else {
			// If the game is not in progress, remove any WindowAdapter registered as "abortOnCloseListener"
			setEnabled(false);
			removeAbortOnCloseListeners();
		}
	}
	
	/** Removes any "abortOnCloseListener" from the MainFrame */
	protected void removeAbortOnCloseListeners() {
		WindowListener[] listener = Jttt.getMainFrame().getWindowListeners();
		for (int index = listener.length - 1; index >= 0; --index) {
			if (listener[index].toString() == abortOnCloseListener.toString()) {
				Jttt.getMainFrame().removeWindowListener((WindowListener) listener[index]);
			}
		}
	}
	
	/** @return whether an abortOnCloseListener is registered for the MainFrame */
	protected boolean isAbortOnCloseListenerRegistered() {
		boolean found = false;
		WindowListener[] listener = Jttt.getMainFrame().getWindowListeners();
		for (int index = listener.length - 1; index >= 0; --index) {
			if (listener[index].toString() == abortOnCloseListener.toString()) {
				found = true;
				break;
			}
		}
		return found;
	}
    /**
     * If the button is clicked, we print a message indicating that the current game is aborted and exit.
     */
    public void actionPerformed(ActionEvent e) {
		jtttAbort();
    }

	/**
	 * Does the real work of aborting the game.
	 */
	public static void jtttAbort() {
		System.out.println("Thou art truly a coward for aborting the game thus!  So be it!");
		ExitAction.jtttExit();
	}

}




/* end AbortAction.java */