/* GameArea.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameArea;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

import jtttGameArea.ChatField.ChatField;
import jtttGameArea.PlayField.PlayField;
import jtttGameArea.StatusField.StatusField;

/**
 * The game area consists of the playing field, status field, and the chat field.
 */
public class GameArea extends JPanel {
	public String toString() {
		return "GameArea";
	}
	
	/** The singleton reference of this class */
	protected static GameArea gameArea = null;
	
	/** Reference of the PlayField */
	protected PlayField playField;
	
	/** Reference of the StatusField */
	protected StatusField statusField;
	
	/** Reference of the chatField */
	protected ChatField chatField;
	
	/** Constructs the GameArea with the necessary subcomponants */
	protected GameArea() {
		playField = new PlayField();
		statusField = new StatusField();
		chatField = new ChatField();
		
		setLayout(new BorderLayout());
		setBorder(new BevelBorder(BevelBorder.LOWERED));
		add(playField, BorderLayout.CENTER);
		add(statusField, BorderLayout.EAST);
		add(chatField, BorderLayout.SOUTH);
	}

    /** gets the singleton reference to the GameArea */
    public static GameArea getGameArea() {
    	if (gameArea == null)
    		gameArea = new GameArea();
    	return gameArea;
	}

    /**
     * @return the reference to the playField
     */
    public PlayField getPlayField() {
        return playField;
    }

    /**
     * @return the reference to the statusField
     */
    public StatusField getStatusField() {
        return statusField;
    }

	/** @return the reference to the chatField */
	public ChatField getChatField() {
		return chatField;
	}
}

/* end GameArea.java */
