/* ChatView.java
 * Created on Apr 8, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameArea.ChatField;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

/**
 * The chat view is the viewing window of the chat and an entry line.
 */
public class ChatView extends JComponent {
	/**
	 * @return A String representation of this class
	 */
	public String toString() {
		return "ChatView";
	}

	protected static ChatView chatView;
	
    /** Constructs and returns the Chat View area, consisting of
    a text area, and one text entry line. */
    protected ChatView() {
    	setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    
    	add(ChatTextArea.getChatTextArea().getChatTextPane());
		add(Box.createVerticalStrut(2));
		add(ChatEntry.getChatEntry());
    }
    
    /**
     * @return the singleton instance of this class
     */
    public static ChatView getChatView() {
    	if (chatView == null)
    		chatView = new ChatView();
        return chatView;
    }

}


/* end ChatView.java */