/* ChatTextArea.java
 * Created on Apr 8, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameArea.ChatField;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;

/**
 * The chat text area is the viewing window of the conversation.
 */
public class ChatTextArea extends JTextArea {

	/**
	 * @return A String representation of this class
	 */
	public String toString() {
		return "ChatTextArea";
	}

	protected static ChatTextArea chatTextArea;
	protected JScrollPane chatTextPane;
	
	protected ChatTextArea() {
		super(7, 40);
		chatTextPane = new JScrollPane(this);
		setBorder(new EtchedBorder());
		setLineWrap(true);
		setFocusable(false);
	}
	
	/** @return the singleton instance of this class */
	public static ChatTextArea getChatTextArea() {
		if (chatTextArea == null)
			chatTextArea = new ChatTextArea();
		return chatTextArea;
	}

	/** @return the scroll pane for the chat text area */
	public JScrollPane getChatTextPane() {
		return chatTextPane;
	}
}

/* end ChatTextArea.java */