/* ChatField.java
 * Created on Apr 8, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameArea.ChatField;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import jtttGameState.GameStateChangeEvent;
import jtttGameState.GameStateListener;

/**
 * The chat field; consists of the chat view and the chat buttons.
 */
public class ChatField extends JPanel implements GameStateListener {

	/**
	 * @return A String representation of this class
	 */
	public String toString() {
	    return "ChatField";
	}
	
	public ChatField() {
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		setBorder(new TitledBorder("<Opponant's Name>"));
    
		add(ChatView.getChatView());
		add(Box.createHorizontalStrut(2));
		add(ChatButtons.getChatButtons());
	}
	/* (non-Javadoc)
	 * @see jtttGameState.GameStateListener#gameStateChanged(jtttGameState.GameStateChangeEvent)
	 */
	public void gameStateChanged(GameStateChangeEvent gsce) {
	    // TODO grey and disable when game is not in progress
	
	}

}

/* end ChatField.java */