/* ChatEntry.java
 * Created on Apr 8, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameArea.ChatField;

import javax.swing.Action;
import javax.swing.JTextField;

import jtttActions.SayAction;

/**
 * The chat entry line.  "Enter" essentially invokes the "Say" action.
 * TODO: replace with the function call to doClick on the say button.
 */
public class ChatEntry extends JTextField {

	/**
	 * @return A String representation of this class
	 */
	public String toString() {
		return "ChatEntry";
	}

	protected static ChatEntry chatEntry;
	
	protected ChatEntry(){
		super(30);
		setAction(SayAction.getSayAction());
		// Set the action command to whatever name we gave the Say action
		setActionCommand((String) SayAction.getSayAction().getValue(Action.NAME));
	}
	
	/** return gets the singleton instance of this class */
	public static ChatEntry getChatEntry() {
		if (chatEntry == null)
			chatEntry = new ChatEntry();
		return chatEntry;
	}
}


/* end ChatEntry.java */