/* ChatButtons.java
 * Created on Apr 8, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttGameArea.ChatField;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;

import jtttActions.GagAction;
import jtttActions.InsultAction;
import jtttActions.SayAction;

/**
 * Singleton class of the chat buttons (say, gag, and insult) inside a container
 */
public class ChatButtons extends JComponent {
	/**
	 * @return A String representation of this class
	 */
	public String toString() {
		return "ChatButtons";
	}

	protected static ChatButtons chatButtons;
	protected JButton sayButton;
	protected JButton gagButton;
	protected JButton insultButton;
	
	protected ChatButtons() {
		sayButton = new JButton(SayAction.getSayAction());
		insultButton = new JButton(InsultAction.getInsultAction());
		gagButton = new JButton(GagAction.getGagAction());
		
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		add(gagButton);
		add(insultButton);
		add(Box.createGlue());
		add(sayButton);
	}
	
	/** @return the singelton instance of this class */
	public static ChatButtons getChatButtons() {
		if (chatButtons == null)
			chatButtons = new ChatButtons();
		return chatButtons;
	}
    /**
     * @return the "Gag" button
     */
    public JButton getGagButton() {
        return gagButton;
    }

    /**
     * @return the "Insult" button
     */
    public JButton getInsultButton() {
        return insultButton;
    }

    /**
     * @return the "Say" button
     */
    public JButton getSayButton() {
        return sayButton;
    }

}

/* end ChatButtons.java */
