/* SayAction.java
 * Created on Mar 11, 2004
 *
 * Part of JTicTacToe
 * (c) beltorak 2004
 * Released under the GPL
 */
package jtttActions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

import jtttGameArea.ChatField.ChatEntry;

/** Say action singleton class */
public class SayAction extends AbstractAction {
	public String toString() {
		return "SayAction singleton";
	}

	protected static SayAction sayAction;

	protected SayAction() {
        putValue(Action.NAME, "Say");
        putValue(Action.SHORT_DESCRIPTION, "Speak Your Mind");
    }

    public void actionPerformed(ActionEvent ae) {
    	String chatText = ChatEntry.getChatEntry().getText();
		Handlers.todo(ae.getActionCommand());
		ChatEntry.getChatEntry().setText(null);
    }

    /** Gets the sayAction */
    public static SayAction getSayAction() {
    	if (SayAction.sayAction == null) {
        	SayAction.sayAction = new SayAction();
        }
        return SayAction.sayAction;
    }
}



/* end SayAction.java */
