/*
 * JgSettingsUI.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgSettings;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import jgDataLoader.CatagoryChangeEvent;
import jgDataLoader.CatagoryChangeListener;
import jgDataLoader.CatagoryListenerList;
import jgGame.JgGameClassic;
import jgGlyphs.GlyphSet;
import jgMain.JgMain;

/**
 * This is a settings dialog.  It contains the catagory selection part, the glyph selection part,
 * and the "Begin" and "Exit" buttons.
 */
public class JgSettingsUI extends JFrame
	implements ActionListener, CatagoryChangeListener
{

	/** Returns the string representation of this class */
	public String toString() {
		return "JgSettingsUI";
	}
	
	/** Protected singleton instance */
	protected static JgSettingsUI ui;

	/** The catagory selection part */
	protected CatagorySelectionUI csUI;
	
	/** The glyph selection part */
	protected GlyphSelectionUI gsUI;

	/** Protected constructor */
	protected JgSettingsUI() {
		super("Java Glyphs");
		getContentPane().setLayout(new BorderLayout());
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		CatagoryListenerList.addCatagoryChangeListener(this);

		csUI = new CatagorySelectionUI();
		gsUI = new GlyphSelectionUI();
	}

	/**
	 * Draws the Settings selection dialog.
	 * This is the only public method, and creates the UI.
	 */
	public static void drawUI() {
		ui = new JgSettingsUI();
		ui.addChildren();
		ui.pack();
		ui.setVisible(true);
	}

	/**
	 * Adds the children of this UI
	 */
	protected void addChildren() {
		ui.getContentPane().add(csUI, BorderLayout.NORTH);
		ui.getContentPane().add(gsUI, BorderLayout.CENTER);

		JPanel ab = new JPanel();
		ab.setLayout(new BoxLayout(ab, BoxLayout.X_AXIS));

		JButton b = new JButton("Begin");
		b.addActionListener(this);
		ab.add(b);
		
		b = new JButton("Exit");
		b.addActionListener(this);
		ab.add(b);
		
		ui.getContentPane().add(ab, BorderLayout.SOUTH);
	}

	public void actionPerformed(ActionEvent e) {
		if ( e.getActionCommand().equals("Exit") ) {
			System.exit(0);
		}
		
		if ( e.getActionCommand().equals("Begin") ) {
			JgMain.getSettings().setGlyphSet(gsUI.getSelected());
			this.dispose();
			JgGameClassic.begin();
		}
	}
	
	public void catagoryChanged(CatagoryChangeEvent e) {
		GlyphSet co = gsUI.getSelected();
		gsUI = new GlyphSelectionUI();
		gsUI.setSelected(co);
		ui.getContentPane().removeAll();
		ui.addChildren();
		ui.pack();
	}

}


/* end JgSettingsUI.java */