/*
 * GlyphSelectionUI.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgSettings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import jgGlyphs.GlyphSet;
import jgMain.JgMain;

/**
 * <I> This description left intentionally blank </I>
 */
public class GlyphSelectionUI extends JPanel {

	/** Returns the string representation of this class */
	public String toString() {
		return "GlyphSelectionUI";
	}

	protected JLabel selectedLabel;
	
	protected GlyphSet availableGlyphs;
	
	protected GlyphSet selectedGlyphs;
	
	protected ActionListener buttonAction = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			if ( selectedGlyphs.contains(e.getActionCommand()) ) {
				selectedGlyphs.removeGlyph(e.getActionCommand());
			} else {
				selectedGlyphs.addGlyph(e.getActionCommand());
			}
			updateLabel();
		}
	};

	public GlyphSelectionUI() {
		super();
		selectedLabel = new JLabel();
		selectedGlyphs = new GlyphSet();
		availableGlyphs = new GlyphSet();

		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		createButtons();
		updateLabel();
		Box labelBox = Box.createHorizontalBox();
		labelBox.add(selectedLabel);
		add(labelBox);
	}
	
	protected void createButtons() {
		// Get all available glyphs based on the selected catagory
		availableGlyphs = JgMain.getDataLoader().getAvailableGlyphs();
		if ( availableGlyphs.size() == 0 ) {
			System.out.println("No available glyphs");
			return;
		}
		JButton[] gbuttons = new JButton[availableGlyphs.size()];
		Box sbox = Box.createHorizontalBox();
		String[] ag = availableGlyphs.toArray();

		for ( int k = 0; k < availableGlyphs.size(); k++ ) {
			if ( k % 10 == 0 ) {
				sbox = Box.createHorizontalBox();
				add(sbox);
			}
			gbuttons[k] = new JButton(ag[k]);
			gbuttons[k].setActionCommand(ag[k]);
			gbuttons[k].addActionListener(buttonAction);
			sbox.add(gbuttons[k]);
		}
	}

	protected void updateLabel() {
		String sel = new String();
		if ( selectedGlyphs.size() == 0 ) {
			sel = "No glyphs selected";
		} else {
			String[] selArr = selectedGlyphs.toArray();
			sel = selArr[0];
			for ( int k = 1; k < selArr.length; k++ ) {
				sel += ", " + selArr[k];
			}
		}
		selectedLabel.setText(sel);
	}
	
	/**
	 * Retrieves the selected glyphs
	 * @return the selected glyphs
	 */
	public GlyphSet getSelected() {
		return selectedGlyphs;
	}
	
	/**
	 * Sets the selected glyphs, pruning them to the available ones.
	 */
	public void setSelected(GlyphSet gs) {
		selectedGlyphs = gs.keepOnly(availableGlyphs);
		updateLabel();
	}
	
}


/* end GlyphSelectionUI.java */