/*
 * CatagorySelectionUI.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgSettings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import jgMain.JgMain;

/**
 * <I> This description left intentionally blank </I>
 */
public class CatagorySelectionUI extends JPanel
	implements ActionListener
{

	/** Returns the string representation of this class */
	public String toString() {
		return "CatagorySelectionUI";
	}

	protected JCheckBox allCatButton;

	protected JComboBox catList;

	public CatagorySelectionUI() {
		super();
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		setBorder(new TitledBorder("Select a Catagory") );
		
		allCatButton = new JCheckBox("Use All Catagories");
		allCatButton.setActionCommand("all-catagories");
		allCatButton.addActionListener(this);
		add(allCatButton);

		catList = new JComboBox(JgMain.getDataLoader().getCatagoryNames());
		catList.setActionCommand("catagory-selection");
		catList.addActionListener(this);
		add(catList);
		
		updateCatagoryDisplay();
	}

	public void updateCatagoryDisplay() {
		JgSettings s = JgMain.getSettings();
		if ( s.getCatagory() == null ) {
			catList.setEnabled(false);
			allCatButton.setSelected(true);
		} else {
			catList.setEnabled(true);
			catList.setSelectedItem(s.getCatagory());
			allCatButton.setSelected(false);
		}
	}

	public void actionPerformed(ActionEvent e) {
		if ( e.getActionCommand().equals("all-catagories") ) {
			if ( allCatButton.isSelected() ) {
				catList.setEnabled(false);
				JgMain.getSettings().setCatagory(null, this);
			} else {
				catList.setEnabled(true);
				JgMain.getSettings().setCatagory( (String) catList.getSelectedItem(), this );
			}
			return;
		}
		
		if ( e.getActionCommand().equals("catagory-selection") ) {
			JgMain.getSettings().setCatagory( (String) catList.getSelectedItem(), this );
			return;
		}
	}

}


/* end CatagorySelectionUI.java */