/*
 * JgMeta.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgMain;

/**
 * Various information about the program
 */
public class JgMeta {
	public static final String version = "0.1";
	public static void printHelp() {
		printVersion();
		printCopyright();
		System.out.println();
		System.out.println("Options:");
		System.out.println("  -g x, --catagory x		Use catagory 'x'");
		System.out.println("  -a, --all-catagories		Use all available catagories");
		System.out.println("  -i dir, --include dir		Include a directory of catagory folders");
		System.out.println("  -l string, --letters string	Use the letters in \"string\"");
		System.out.println("  --sequence : string list :	Use the string fragments in \"string list\"");
		System.out.println("				This is a colin delimeted list of string fragments, ie \": ch ing str :\"");
		System.out.println("  -v, --version			Print version");
		System.out.println("  -h, -?, --help		Print this help");
		System.out.println("Note: short options may not be combined.");
		System.out.println();
	}

	public static void printVersion() {
		System.out.println("JGlyphs version " + version);
	}
	
	public static void printCopyright() {
		System.out.println("(c) 2004 Trevor \"beltorak\" Torrez");
		System.out.println("Released under the GPL, either version 2, or at your preference, any later version.");
		System.out.println("See the file \"COPYING.txt\" included in the distribution for details.");
	}
}


/* end JgMeta.java */