/*
 * JgMain.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgMain;

import jgDataLoader.DataLoader;
import jgGame.JgGameClassic;
import jgSettings.JgSettings;
import jgSettings.JgSettingsUI;

/**
 * <I> This description left intentionally blank </I>
 */
public class JgMain {

	/** A reference to the DataLoader instance */
	protected static DataLoader dl;

	/** A reference to the program settings */
	protected static JgSettings settings;

	/** duh */
	public static void main(String[] args) {
		settings = new JgSettings(args);
		dl = new DataLoader();
		if ( settings.getCatagory() != null && ! dl.isCatagoryValid(settings.getCatagory()) ) {
			System.out.println( "Invalid catagory " + settings.getCatagory() );
			System.exit(1);
		}
		if ( settings.shouldDrawUI() ) {
			JgSettingsUI.drawUI();
		} else {
			JgGameClassic.begin();
		}
	}
	
	/**
	 * Retrieves the settings object
	 * @return the JgSettings object
	 */
	public static JgSettings getSettings() {
		return settings;
	}

	/**
	 * Retreives the data loader instance
	 * @return the DataLoader object
	 */
	public static DataLoader getDataLoader() {
		return dl;
	}

}


/* end JgMain.java */