/*
 * JgDebug.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgMain;


/**
 * <I> This description left intentionally blank </I>
 */
public class JgDebug extends Throwable {

	/** The level of depth in the current debugging object */
	protected int intr = 0;

	/**
	 * Prints a debuging message.  Follows up with the current location in the source.
	 * @param msg The string to print
	 */
	public void notify(String msg) {
		intr++;
		System.out.println(getCurrentMethod() + " " + msg + " [at " + getCurrentLocation() + "]");
		intr--;
	}

	/**
	 * Prints the current location in the source.
	 */
	public void printCurrentMethod() {
		intr++;
		System.out.println(getCurrentMethod());
		intr--;
	}
	
	/**
	 * Gets the current method in the source
	 */
	public String getCurrentMethod() {
		intr++;
		StackTraceElement[] ste = new Throwable().getStackTrace();
		String cName = ste[intr].getClassName().toString().substring(ste[intr].getClassName().toString().lastIndexOf(".") + 1);
		String mName = ste[intr].getMethodName();
		intr--;
		return cName + "::" + mName + "()";
	}
	
	/**
	 * Gets the current location in the source
	 */
	public String getCurrentLocation() {
		intr++;
		StackTraceElement[] ste = new Throwable().getStackTrace();
		String cl = ste[intr].getFileName() + ": Line " + ste[intr].getLineNumber();
		intr--;
		return cl;
	}

	/**
	 * Prints a notification that a method has been entered.
	 * This is a convenience wrapper for print("entered");
	 */
	public void notifyMethodEntered() {
		intr++;
		notify("++ entered ++");
		intr--;
	}
	
	/**
	 * Prints a notification that a method has been exited.
	 * This is a convenience wrapper for print("exited");
	 */
	public void notifyMethodExit() {
		intr++;
		notify("-- exited --");
		intr--;
	}

	/**
	 * A simple wrapper around System.out.println("");
	 * This is here to conveniently locate debugging messages in the source.
	 */
	public void println(String msg) {
		System.out.println(msg);
	}
	
	/**
	 * Crashes the program for the following reason:
	 * @param reason the reason that we crashed
	 */
	public void crash(String reason) {
		intr++;
		notify("*** Fatal Error: " + reason);
		new Throwable().printStackTrace();
		System.exit(1);
	}
	
	/**
	 * Prints a stack trace up to a certain limit.
	 * @param lim the limit to print the stack trace to
	 */
	public void printStackTrace(int lim) {
		intr++;
		StackTraceElement[] ste = new Throwable().getStackTrace();
		for ( int k = intr; k <= lim && lim < ste.length; k++ ) {
			System.out.println(ste[k].toString());
		}
		intr--;
	}
}


/* end JgDebug.java */