/*
 * CatagoryListenerList.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgDataLoader;

import javax.swing.event.EventListenerList;

/**
 * Maintains the list of CatagoryChangeListeners.
 * This is a sngleton clobject.
 */
public class CatagoryListenerList extends EventListenerList {

	/** Returns the string representation of this class */
	public String toString() {
		return "CatagoryListenerList";
	}

	/** Singleton instance of this clobject */
	protected static CatagoryListenerList cll;
	
	/** Constructor */
	protected CatagoryListenerList() {
		super();
	}

	/** Returns the singleton instance of this clobject */
	protected static CatagoryListenerList getList() {
		if ( cll == null ) {
			cll = new CatagoryListenerList();
		}
		return cll;
	}

	/**
	 * Alerts all listeners that the catagory has changed.
	 * @param src the object that generated the event.
	 */
	public static void fireCatagoryChangeEvent(Object src) {
		CatagoryChangeEvent e = new CatagoryChangeEvent(src);
		CatagoryChangeListener[] ccl = (CatagoryChangeListener[]) getList().getListeners(CatagoryChangeListener.class);
		for ( int k = 0; k < ccl.length; k++ ) {
			ccl[k].catagoryChanged(e);
		}
	}
	
	/** Adds a catagory change listener to the registry */
	public static void addCatagoryChangeListener(CatagoryChangeListener c) {
		getList().add(CatagoryChangeListener.class, c);
	}
	
	/** Removes a catagory change listener */
	public static void removeCatagoryChangeListener(CatagoryChangeListener c) {
		getList().remove(CatagoryChangeListener.class, c);
	}

}


/* end CatagoryListenerList.java */