/*
 * CatagoryList.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgDataLoader;

import java.util.Vector;


/**
 * This class contains the list of available catagories.
 */
public class CatagoryList {

	/** Returns the string representation of this class */
	public String toString() {
		return "CatagoryList";
	}

	/** Private list of catagories as strings */
	protected Vector catagoryList;
	
	/** Constructs the catagory list */
	public CatagoryList() {
		catagoryList = new Vector(10, 10);
	}

	/** @return an array of Strings representing the names of available catagories */
	public String[] getCatagories() {
		return (String[]) catagoryList.toArray(new String[catagoryList.size()]);
	}
	
	/** Adds a catagory to the list */
	public void add(String name) {
		if ( ! catagoryList.contains(name) ) {
			catagoryList.add(name);
		}
	}

	/**
	 * Removes a catagory from the list.
	 * @param name the name of the catagory to remove
	 */
	public void remove(String name) {
		catagoryList.remove(name);
	}
	
	/**
	 * Checks to see if a catagory is in the list.
	 * @param name the catagory name to check
	 * @return true if the name exists in the list, false otherwise
	 */
	public boolean contains(String name) {
		return catagoryList.contains(name);
	}
}


/* end CatagoryList.java */