/*
 * CatagoryChangeEvent.java, part of JGlyphs
 * 
 * (c) 2004 Trevor "beltorak" Torrez
 * Released under the GPL, either version 2, or at your preference,
 * any later version.
 * 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package jgDataLoader;

import java.util.EventObject;

/**
 * This is an event object signifying that the catagory has changed.
 * Interested parties should query settings.catagory to get the current
 * catagory name.
 */
public class CatagoryChangeEvent extends EventObject {
	/** Returns the string representation of this class */
	public String toString() {
		return "CatagoryChangeEvent";
	}

	/** Constructor.  The only thing of import is the name of the new catagory */
	public CatagoryChangeEvent(Object src) {
		super(src);
	}

}


/* end CatagoryChangeEvent.java */