/*******************************************************************/
/* LIST.C - main control program for LIST.EXE                      */
/* Copyright (c) 1994 Coronado Enterprises                         */
/*                                                                 */
/* This program will read in any text file and print it with line  */
/*  numbers and with page numbers.  It is meant to be a listing    */
/*  program for source code.                                       */
/*                                                                 */
/* This program depends very heavily on the LISTF.C file which     */
/*  contains the working functions to implement the printing       */
/*  functionality.                                                 */
/*******************************************************************/

#include <stdio.h>             /* standard I/O header file         */
#include "listf.h"

int main(int argc, char *argv[])
{
int return_value;              /* end of file indicator            */

   if (open_in_file(argc, argv[1]))  /* open the file to print     */
      return (1);              /* did not open properly            */
   if (open_printer())         /* open the printer driver          */
      return (1);              /* did not open properly            */

   do {
      return_value = read_one_line();   /* read a line into buffer */
      if (return_value)
         top_of_page();        /* start a new page if necessary    */
         print_one_line();     /* print the line                   */
   } while (return_value);     /* continue until EOF               */

   eject_page();               /* eject the last page              */
   close_both_files();         /* close the file and printer       */
   return (0);
}
