'Title: "Air Hockey"
'Program: AIRHOCK2.BAS
'Creation Date: July 24th 1996
'Version 1.0 Note: July 1998 {project terminated}
'
'Revisitation Date: March 21st 1999
'Amendment Date: March 21st 1999
'Game Version: v2.0
'
'Programmer: Zenteran (Chad D. Snyder)
'Area: New Westminster, British Columbia
'Email: zenteran@hotmail.com
'
'Additional Note: This is one of my first games and is very basic (no pun
'  intended). You are free to do whatever you wish to do with this game;
'  however, if you modify it or use it, email me the finished modified
'  result. :) Oh yeah, tell me where you got this program and what country
'  you live in. Ideal for beginner programmers as a learning tool because it
'  is highly commented.
'
'As a challenge: Restricted to only the six original subroutines which are
'StartPlay, PlayField, InitGraphic, PointContinue, DrawPieces & MovePieces.
'
DECLARE SUB StartPlay ()
DECLARE SUB PlayField ()
DECLARE SUB InitGraphic ()
DECLARE SUB PointContinue ()
DECLARE SUB DrawPieces ()
DECLARE SUB MovePieces ()

DIM SHARED Puck%(37), Computer%(133), Player%(133)
COMMON SHARED PPoints%, CPoints%
COMMON SHARED CXPos%, CXPrevPos%, CYPos%, CYPrevPos%
COMMON SHARED PXPos%, PXPrevPos%, PXSpeed%, PYPos%, PYPrevPos%, PYSpeed%
COMMON SHARED BXPos%, BXPrevPos%, BXSpeed%, BYPos!, BYPrevPos!, BYAngle!
COMMON SHARED InDemo%, CompSkill%

CONST No = 0, Yes = 1
CONST Computer = 0, Player = 1
CONST Offensive = 0, Defensive = 1

CONST Sfx% = Yes

ON ERROR GOTO ProgError

SCREEN 8

InitGraphic

PlayField

RANDOMIZE TIMER

'*Variable Initiation*
'Puck Variables
LET BXPos% = 320: BXPrevPos% = 320
LET BYPos! = 100: BYPrevPos! = 100
LET BXSpeed% = INT(RND * 2)
IF BXSpeed% = 0 THEN LET BXSpeed% = -2
IF BXSpeed% = 1 THEN LET BXSpeed% = 2
LET BYAngle! = INT(RND * 3) - 1
'Paddle Variables
LET CXPos% = 28: CXPrevPos% = 28: CYPos% = 85: CYPrevPos% = 85: CPoints% = 0
LET PXPos% = 590: PXPrevPos% = 590: PYPos% = 85: PYPrevPos% = 85: PPoints% = 0
LET PXSpeed% = 0: PYSpeed% = 0

StartPlay
LOCATE 1, 28: PRINT "*** AIR HOCKEY (V2.0) ***"
LOCATE 2, 33: PRINT "BY: CHAD SNYDER"
LOCATE 1, 1: PRINT "COMPUTER": LOCATE 2, 3: PRINT CPoints%
LOCATE 1, 74: PRINT "PLAYER": LOCATE 2, 75: PRINT PPoints%
LOCATE 23, 1: PRINT "END = ABORT PROGRAM"

MovePieces

'*Unexpected Error Trap*
ProgError:
LOCATE 23, 1: PRINT "THERE WAS AN ERROR DURING PROGRAM EXECUTION. ";
PRINT "THE PROGRAM WILL BE TERMINATED."
END

DEFINT A-Z
SUB DrawPieces
PUT (BXPrevPos%, BYPrevPos!), Puck%: PUT (BXPos%, BYPos!), Puck%
IF CXPrevPos% <> CXPos% OR CYPrevPos% <> CYPos% THEN
 PUT (CXPrevPos%, CYPrevPos%), Computer%: PUT (CXPos%, CYPos%), Computer%
END IF
IF PXPrevPos% <> PXPos% OR PYPrevPos% <> PYPos% THEN
 PUT (PXPrevPos%, PYPrevPos%), Player%: PUT (PXPos%, PYPos%), Player%
END IF
WAIT &H3DA, 8
END SUB

SUB InitGraphic

'*Puck Graphic*
CIRCLE (160, 100), 4, 15, , , 1: PAINT (160, 100), 14, 15
GET (156, 96)-(164, 104), Puck%

'*Computer/Player Paddle Graphics*
CIRCLE (11, 11), 10, 15, , , 1: PAINT (11, 11), 15, 15
CIRCLE (11, 11), 5, 8, , , 1: PAINT (11, 11), 7, 8
GET (1, 1)-(22, 22), Computer%: GET (1, 1)-(22, 22), Player%

CLS

END SUB

SUB MovePieces

PUT (BXPos%, BYPos!), Puck%
PUT (CXPos%, CYPos%), Computer%
PUT (PXPos%, PYPos%), Player%

DO
LET BXPos% = BXPos% + BXSpeed%: BYPos! = BYPos! + BYAngle!

'*Puck bounces off the top/bottom barriers*
IF BYPos! < 27 OR BYPos! > 156 THEN
 IF BYPos! < 27 THEN LET BYPos! = 27
 IF BYPos! > 156 THEN LET BYPos! = 156
 IF Sfx% = Yes THEN SOUND 300, .1
 LET BYAngle! = -BYAngle!
END IF
'*Puck bounces off the left/right barriers*
IF (BXPos% > 605 AND (BYPos! < 75 OR BYPos! > 115)) OR (BXPos% < 27 AND (BYPos! < 75 OR BYPos! > 115)) THEN
'IF BXPos% > 605 OR BXPos% < 27 THEN
 IF BXPos% < 27 THEN LET BXPos% = 27
 IF BXPos% > 605 THEN LET BXPos% = 605
 IF Sfx% = Yes THEN SOUND 300, .1
 LET BXSpeed% = -BXSpeed%
END IF

'*Computer Paddle/Puck Collision*
IF BXPos% > CXPos% AND BXPos% < CXPos% + 23 AND BYPos! + 8 > CYPos% AND BYPos! < CYPos% + 20 THEN
 IF BXPos% < CXPos% + 23 THEN LET BXPos% = CXPos% + 23
 IF Sfx% = Yes THEN SOUND 200, .1: SOUND 300, .1
 LET BXSpeed% = (BXSpeed% - 1) * -1
 IF ABS(BXSpeed%) > 18 THEN LET BXSpeed% = SGN(BXSpeed%) * 18
 LET BYAngle! = BYAngle! + ((BYPos! + 4) - (CYPos% + 12.5)) / 6 'Puck English
 IF BYAngle! = 0 THEN LET BYAngle! = INT(RND * 3) - 1
 IF ABS(BYAngle!) > 6 THEN BYAngle! = SGN(BYAngle!) * 6
END IF

'*Player Paddle/Puck Collision*
IF BXPos% < PXPos% + 17 AND BXPos% > PXPos% - 10 AND BYPos! + 8 > PYPos% AND BYPos! < PYPos% + 20 THEN
 IF BXPos% > PXPos% - 10 THEN LET BXPos% = PXPos% - 10
 IF Sfx% = Yes THEN SOUND 200, .1: SOUND 300, .1
 LET BXSpeed% = (BXSpeed% + 1) * -1
 IF ABS(BXSpeed%) > 18 THEN LET BXSpeed% = SGN(BXSpeed%) * 18
 LET BYAngle! = BYAngle! + ((BYPos! + 4) - (PYPos% + 12.5)) / 6 'Puck English
 IF BYAngle! = 0 THEN LET BYAngle! = INT(RND * 3) - 1
 IF ABS(BYAngle!) > 6 THEN BYAngle! = SGN(BYAngle!) * 6
END IF

IF BXPos% < 1 OR BXPos% > 627 THEN PointContinue

Kbd$ = INKEY$
IF Kbd$ = CHR$(0) + "O" THEN 'End: Abort Game
 LOCATE 10, 36: PRINT "GAME OVER": END
END IF
IF InDemo% = No THEN
 IF Kbd$ = " " THEN PYSpeed% = 0: PXSpeed% = 0 'Space: Stop Moving
 IF Kbd$ = CHR$(0) + "K" THEN LET PXSpeed% = PXSpeed% - 2 ': Move Left
 IF Kbd$ = CHR$(0) + "M" THEN LET PXSpeed% = PXSpeed% + 2 ': Move Right
 IF Kbd$ = CHR$(0) + "H" THEN PYSpeed% = PYSpeed% - 1 ': Move Up
 IF Kbd$ = CHR$(0) + "P" THEN PYSpeed% = PYSpeed% + 1 ': Move Down
 IF ABS(PXSpeed%) > 20 THEN PXSpeed% = SGN(PXSpeed%) * 20 'Horizontal Speed
 IF ABS(PYSpeed%) > 20 THEN PYSpeed% = SGN(PYSpeed%) * 20 'Vertical Speed
 LET PXPos% = PXPos% + PXSpeed%: LET PYPos% = PYPos% + PYSpeed%
END IF

'*Computer Paddle moves to hit the Puck when it enters its area of play*
IF (InDemo% = No AND CompSkill% = Offensive) OR InDemo% = Yes THEN
 IF CXPos% < BXPos% AND BXPos% > 320 AND BXSpeed% = -ABS(BXSpeed%) THEN
  LET CXPos% = CXPos% + PPoints% + 2
  IF CYPos% > 85 THEN LET CYPos% = CYPos% - PPoints% - 1
  IF CYPos% < 85 THEN LET CYPos% = CYPos% + PPoints% + 1
 END IF
 IF CXPos% > BXPos% + 20 AND BXPos% < 320 AND BXSpeed% = -ABS(BXSpeed%) THEN LET CXPos% = CXPos% - PPoints% - 2
 IF CYPos% < BYPos! - 9 AND BXPos% < 320 AND BXSpeed% = -ABS(BXSpeed%) THEN LET CYPos% = CYPos% + PPoints% + 1
 IF CYPos% > BYPos! - 9 AND BXPos% < 320 AND BXSpeed% = -ABS(BXSpeed%) THEN LET CYPos% = CYPos% - PPoints% - 1
ELSEIF InDemo% = No AND CompSkill% = Defensive THEN
 IF CXPos% < BXPos% AND BXPos% > 320 AND BXSpeed% = -ABS(BXSpeed%) THEN
  LET CXPos% = CXPos% + PPoints% + 2
  IF CYPos% > 85 THEN LET CYPos% = CYPos% - PPoints% - 1
  IF CYPos% < 85 THEN LET CYPos% = CYPos% + PPoints% + 1
 END IF
 IF CXPos% > BXPos% + 20 AND BXPos% < 320 AND BXSpeed% = -ABS(BXSpeed%) THEN LET CXPos% = CXPos% - PPoints% - 2
 IF CYPos% < BYPos! - 9 AND BXPos% < 320 AND BXSpeed% = -ABS(BXSpeed%) THEN LET CYPos% = CYPos% + PPoints% + 1
 IF CYPos% > BYPos! - 9 AND BXPos% < 320 AND BXSpeed% = -ABS(BXSpeed%) THEN LET CYPos% = CYPos% - PPoints% - 1
 '*Computer Paddle returns to goal when the Puck heads towards the player*
 IF CXPos% > 28 AND BXSpeed% = ABS(BXSpeed%) THEN LET CXPos% = CXPos% - PPoints% - 2
 IF CYPos% > 85 AND BXSpeed% = ABS(BXSpeed%) THEN LET CYPos% = CYPos% - PPoints% - 1
 IF CYPos% < 85 AND BXSpeed% = ABS(BXSpeed%) THEN LET CYPos% = CYPos% + PPoints% + 1
END IF
  
IF InDemo% = Yes THEN
 '*Player Paddle moves to hit the Puck when it enters its area of play*
 IF PXPos% < BXPos% + 20 AND BXPos% > 320 AND BXSpeed% = ABS(BXSpeed%) THEN
  LET PXPos% = PXPos% + CPoints% + 2
 ELSEIF PXPos% > BXPos% AND BXSpeed% = ABS(BXSpeed%) THEN
  LET PXPos% = PXPos% - CPoints% - 2
 END IF
 IF PYPos% > BYPos! - 9 AND BXPos% > 320 AND BXSpeed% = ABS(BXSpeed%) THEN LET PYPos% = PYPos% - CPoints% - 1
 IF PYPos% < BYPos! - 9 AND BXPos% > 320 AND BXSpeed% = ABS(BXSpeed%) THEN LET PYPos% = PYPos% + CPoints% + 1
 '*Player Paddle returns to goal when the Puck heads towards the computer*
 IF PXPos% < 590 AND (BXSpeed% = -ABS(BXSpeed%) OR BXSpeed% = ABS(BXSpeed%) AND BXPos% < 320) THEN LET PXPos% = PXPos% + CPoints% + 2
 IF PYPos% > 85 AND BXSpeed% = -ABS(BXSpeed%) THEN LET PYPos% = PYPos% - CPoints% - 1
 IF PYPos% < 85 AND BXSpeed% = -ABS(BXSpeed%) THEN LET PYPos% = PYPos% + CPoints% + 1
END IF

IF CXPos% < 28 THEN LET CXPos% = 28
IF InDemo% = Yes AND CXPos% > 180 THEN LET CXPos% = 180
IF CXPos% > 300 THEN LET CXPos% = 300
IF CYPos% < 27 THEN LET CYPos% = 27
IF CYPos% > 144 THEN LET CYPos% = 144

IF PXPos% > 590 THEN LET PXPos% = 590: LET PXSpeed% = 0
IF InDemo% = Yes AND PXPos% < 460 THEN LET PXPos% = 460
IF PXPos% < 321 THEN LET PXPos% = 321: LET PXSpeed% = 0
IF PYPos% < 27 THEN LET PYPos% = 27: LET PYSpeed% = 0
IF PYPos% > 144 THEN LET PYPos% = 144: LET PYSpeed% = 0

DrawPieces

'*Remember previous positions*
LET CXPrevPos% = CXPos%: CYPrevPos% = CYPos%
LET PXPrevPos% = PXPos%: PYPrevPos% = PYPos%
LET BXPrevPos% = BXPos%: BYPrevPos! = BYPos!
LOOP

END SUB

SUB PlayField

FOR A = 0 TO 640
 IF A <= 16 THEN 'Vertical Seperators
  PSET (65, A), 15: PSET (90, A), 15: LINE (66, A)-(89, A), 1
  PSET (549, A), 15: PSET (574, A), 15: LINE (550, A)-(573, A), 1
 END IF
 LET T = 16: IF A > 65 AND A < 90 OR A < 574 AND A > 549 THEN LET T = 0
 PSET (A, T), 15: PSET (A, 175), 15'Outside top/bottom
 IF A >= 26 AND A <= 614 THEN
  PSET (A, 26), 15: PSET (A, 165), 15'Inside top/bottom
 ELSE
  PSET (A, 75), 15: PSET (A, 115), 15' Ends of left/right sides
 END IF
 IF A >= 76 AND A <= 114 THEN 'Left/right goals
  PSET (17, A), 15: PSET (18, A), 15
  PSET (623, A), 15: PSET (622, A), 15
 END IF
 IF A >= 17 AND A <= 26 OR A >= 166 AND A <= 174 THEN 'Top/bottom ends
  PSET (0, A), 15: PSET (639, A), 15: LINE (1, A)-(638, A), 1
 END IF
 IF A >= 26 AND A <= 74 OR A >= 116 AND A <= 165 THEN 'Left/right sides
  PSET (0, A), 15: PSET (25, A), 15: LINE (1, A)-(24, A), 1
  PSET (614, A), 15: PSET (639, A), 15: LINE (615, A)-(638, A), 1
 END IF
NEXT A

END SUB

SUB PointContinue
  
IF BXPos% < 1 THEN 'The Player scored
 Scored% = Player
 LET PPoints% = PPoints% + 1
 LOCATE 2, 75: PRINT PPoints%
 IF PPoints% = 10 THEN ' IF THE PLAYER GETS 10 POINTS, THE GAME ENDS
  LOCATE 8, 33: PRINT "THE PLAYER WINS!"
  LOCATE 10, 36: PRINT "GAME OVER"
  END
 END IF
END IF
IF BXPos% > 627 THEN 'The Computer scored
 Scored% = Computer
 LET CPoints% = CPoints% + 1
 LOCATE 2, 3: PRINT CPoints%
 IF CPoints% = 10 THEN ' IF THE COMPUTER GETS 10 POINTS, THE GAME ENDS
  LOCATE 8, 32: PRINT "THE COMPUTER WINS!"
  LOCATE 10, 36: PRINT "GAME OVER"
  END
 END IF
END IF

' * RESETS THE Variables FOR Puck% SO ANOTHER ROUND CAN BE PLAYED *
LET BXPos% = 320: BYPos! = 100
LET PXSpeed% = 0: PYSpeed% = 0
IF Scored% = Player THEN LET BXSpeed% = -2 'Puck goes towards the Computer
IF Scored% = Computer THEN LET BXSpeed% = 2 'Puck goes towards the Player
LET BYAngle! = INT(RND * 3) - 1

IF InDemo% = No THEN
 LOCATE 10, 28: PRINT "PRESS [RETURN] TO SERVE"
 DO
  LET NIL$ = INKEY$
  IF NIL$ = CHR$(0) + "O" THEN 'End: Abort Game
   LOCATE 10, 28: PRINT STRING$(23, " ")
   LOCATE 10, 36: PRINT "GAME OVER"
   END
  END IF
 LOOP UNTIL NIL$ = CHR$(13)
 LOCATE 10, 28: PRINT STRING$(23, " ")
END IF

END SUB

SUB StartPlay

LOCATE 10, 28: PRINT "PRESS [RETURN] TO BEGIN"
DO: LOOP UNTIL INKEY$ = CHR$(13)
LOCATE 10, 28: PRINT "1 = DEMO       2 = PLAY"
k = 0: DO: k = VAL(INKEY$): LOOP UNTIL k = 1 OR k = 2
LOCATE 15, 30: PRINT "ARROW KEYS TO MOVE"
LOCATE 16, 32: PRINT "RIGHT 'GOALIE'!"
LOCATE 10, 28: PRINT "                       "
IF k = 1 THEN
 InDemo% = Yes
ELSE
 InDemo% = No
 LOCATE 9, 32: PRINT "COMPUTER SKILL?"
 LOCATE 10, 33: PRINT "1 = OFFENSIVE"
 LOCATE 11, 33: PRINT "2 = DEFENSIVE"
 k = 0: DO: k = VAL(INKEY$): LOOP UNTIL k = 1 OR k = 2
 IF k = 1 THEN CompSkill% = Offensive ELSE CompSkill% = Defensive
END IF
LOCATE 9, 28: PRINT "                       "
LOCATE 10, 28: PRINT "                       "
LOCATE 11, 28: PRINT "                       "
LOCATE 15, 28: PRINT "                       "
LOCATE 16, 28: PRINT "                       "


END SUB

