pushad
;********************* Init delay by finding speed of loop instruction ***************
initdelay:
	or word [fs:sys_int_mask], 0100h	;0000000100000000xb = set bit8 so that system multitasking knows

	hlt				;wait for int8 again to catch it right at the beginning of the 1/18.2 of a sec.
	nop		;when it returns, it will be 6 bytes ahead, so make sure it ends on an instruction...
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	mov ecx, 0ffffffffh
initdelay_clockloop:	loop initdelay_clockloop
	nop
	nop
	nop
	nop
	nop
	nop			;By here, ecx = 0ffffffffh - # loops.
	nop
	nop

	and word [fs:sys_int_mask], 0feffh	;1111111011111111xb = clear bit 8 to release int8

	mov eax, 0ffffffffh
	sub eax, ecx		;now eax = number of loops were completed in 18.2 sec

	fild dword [fs:cpu_speed]	;load cpu speed
	mov dword [fs:loop_cycles], 041919999h	;binary real encoding for 18.2
	fdiv dword [fs:loop_cycles]	;divide hertz by 18.2 to get cycles per (1/18.2 sec)
	mov dword [fs:loop_cycles], eax	;get ready to divide the processors ^above^ by # times loop opcode executed
	fidiv dword [fs:loop_cycles]	;This should give # cycles for the loop instruction
	fstp dword [fs:loop_cycles]	;Save this number and pop the value from the fpu stack. NOTE: This is not an integer.
					;It will be more accurate to leave it as a 32-bit real.
end_initdelay:

;********************* Initialize the Memory Manager *********************
	;Mem manager format: 1st dword = # entries, each entry has two dwords: offset & the offset of the first available byte
	;				 in memory after it. An entry at offset 0100000h that is 1MB long will have 200000h in
	;				 its second dword because its 1MB will have its last byte on 1fffffh.
	push fs
	mov ax, mem_data_sel
	mov fs, ax

	mov dword [fs:0], 2		;Only 2 entries so far (kernel & its stuff already in memory & high 360KB for 
					;video and other memory mapped stuff)
	mov dword [fs:4], 0		;Offset 0 is used for dma xfers from/to floppy.
	mov dword [fs:8], original_offset + gdt_start + 024000h ;(enough room for kernel (original_offset + gdt_start()
					;plus enough room for GDT 10000h and mem_data_sel 10000h and gdt_free_sel 4000h)
	mov dword [fs:12], 0a0000h	;First video area
	mov dword [fs:16], 0100000h	;Last 384KB (0100000h - a0000h) of 1st MB of memory are reserved for video and 
					;memory mapped I/O
	pop fs

;******************** Clear gdt_free_sel segment to all 0's *********************
	push es
	mov ax, gdt_free_sel
	mov es, ax
	xor eax, eax
	mov ecx, 02000h		;8000h / 4 bytes per dword = 2000h
	mov edi, 0
	rep stosd		;Put all 0's into gdt_free_sel
	pop es

;******************** Fill unused GDT entries with all zeroes *********************
	push es
	mov ax, gdt_image
	mov es, ax
	mov edi, dword [fs:gdt_size]
	mov ecx, 65536
	sub ecx, edi
	shr ecx, 2		;Divide by 4 to get the number of dwords
	xor eax, eax
	rep stosd
	pop es

;********************* Get info. from hard drive(s) *********************
        push es				;need to push es, because hdinfo returns a pointer to the data in es
	;**** Look & get params for hard disk on hdc0, master
	xor al, al
        call sys_hdinfo_csel:0
        mov al, byte [es:temp_numheads]
        mov byte [fs:hd0_numheads], al
        mov ax, word [es:temp_numcylinders]
        mov word [fs:hd0_numcylinders], ax
        mov ax, word [es:temp_numsectors]
        mov word [fs:hd0_numsectors], ax
	call refresh_params
	;**** HDC0, slave
	mov al, 010h
	call sys_hdinfo_csel:0
        mov al, byte [es:temp_numheads]
        mov byte [fs:hd1_numheads], al
        mov ax, word [es:temp_numcylinders]
        mov word [fs:hd1_numcylinders], ax
        mov ax, word [es:temp_numsectors]
        mov word [fs:hd1_numsectors], ax
	call refresh_params
	;**** HDC1, master
	mov al, 080h
        call sys_hdinfo_csel:0
        mov al, byte [es:temp_numheads]
        mov byte [fs:hd2_numheads], al
        mov ax, word [es:temp_numcylinders]
        mov word [fs:hd2_numcylinders], ax
        mov ax, word [es:temp_numsectors]
        mov word [fs:hd2_numsectors], ax
	call refresh_params
	;**** HDC1, slave
	mov al, 090h
	call sys_hdinfo_csel:0
        mov al, byte [es:temp_numheads]
        mov byte [fs:hd3_numheads], al
        mov ax, word [es:temp_numcylinders]
        mov word [fs:hd3_numcylinders], ax
        mov ax, word [es:temp_numsectors]
        mov word [fs:hd3_numsectors], ax
	call refresh_params
        pop es
	jmp over_refreshparams
refresh_params:
	mov ecx, 080h
	xor eax, eax
	mov edi, eax
	rep stosd
	ret
over_refreshparams:
;*********************** Enable A20 Line ************************
jmp over_kbdwait
	kbdw0:	jmp short $+2
	in al,0x60
kbdwait:jmp short $+2
	in al,0x64
	test al,1
	jnz kbdw0
	test al,2
	jnz kbdwait
	ret

over_kbdwait:
; enable A20 line. I tried the code from Freedows '98 ldr_asm.asm
; but it didn't work, so use Linux arch/i386/boot/setup.s
a20_chk:call kbdwait
	mov al,0xD1
	out 0x64,al
	call kbdwait
	mov al,0xDF
	out 0x60,al
	call kbdwait

;******************** Count amount of memory **********************
	call sys_mem_count_csel:0
	mov dword [fs:memory_count], ecx

;************* Create Devices, Task Data, and User Segments ************
	push es

	mov ecx, task_data_size
	mov eax, 4012h	;01000000 00010010xb
	call sys_alloc_mem_csel:0
	mov word [fs:task_sel], ax
	mov ecx, task_data_size
	call init_to_zeroes

	mov ecx, device_data_size
	mov eax, 04012h
	call sys_alloc_mem_csel:0
	mov word [fs:device_sel], ax
	mov ecx, device_data_size
	call init_to_zeroes

	mov ecx, user_data_size
	mov eax, 04012h
	call sys_alloc_mem_csel:0
	mov word [fs:user_sel], ax
	mov ecx, user_data_size
	call init_to_zeroes

	jmp init_on_to_cls

init_to_zeroes:
	mov es, ax
	xor edi, edi
	xor al, al
	rep stosb
	ret

init_on_to_cls:
	pop es
;*********************** Clear Screen ************************
	call sys_cls_csel:0

;********************** Finish Up **************************
	popad