display_info:
	pushad
	push ds
	push es

	mov ax, shared_data_sel
	mov ds, ax

	mov esi, temp_data8	;print "Processor Brand: "
	mov al, white
	call sys_print_csel:0

	pushfd			;This section of code tries to set bit21 of eflags
	pop eax			;If successful then supports cpuid instruction
	or eax, 0200000h
	push eax
	popfd
	pushfd
	pop eax
	and eax, 0200000h
	jnz supports_cpuid

	mov dword [fs:cpu_type], "Real"	;print Really Old! if it doesn't support
	mov dword [fs:cpu_type + 4], "ly O"	;cpuid
        mov dword [fs:cpu_type + 8], "ld! "
        mov byte [fs:cpu_type + 11], 0
        jmp display_type

supports_cpuid:
	mov eax, 0				;If it supports cpuid, get processor type
	cpuid
	mov dword [fs:cpu_type], ebx
	mov dword [fs:cpu_type + 4], edx
	mov dword [fs:cpu_type + 8], ecx
	mov byte [fs:cpu_type + 12], 0
display_type:
	mov esi, cpu_type			;Print the string with the name of the
	mov al, white				;processor type
	call sys_print_csel:0
	
	mov esi, temp_data1			;Print "CPU Speed: "
	mov al, white
	call sys_print_csel:0

	mov ax, shared_data_sel
	mov es, ax
	mov edi, temp_data1
	mov eax, dword [fs:cpu_speed]
	call lib_bin_dec_csel:0			;convert the cpu speed into a decimal asciiz
						;string
	mov esi, temp_data1
	mov al, white
	call sys_print_csel:0			;Print the CPU speed asciiz string
	and byte [fs:temp_mask], 0feh		;free this temp. memory position for use.

	mov esi, temp_data4			;print "hertz" after the cpu speed
	mov al, white
	call sys_print_csel:0

	mov esi, temp_data2			;print "Memory: "
	mov al, white
	call sys_print_csel:0

	call sys_mem_count_csel:0		;Count the amount of memory
	mov dword [fs:memory_count], ecx	;save the # of kbytes

	mov edi, temp_data2			;convert the amount of mem into an asciiz
	mov eax, dword [fs:memory_count]	;string
	call lib_bin_dec_csel:0

	mov esi, temp_data2			;Print the amount of memory
	mov al, white
	call sys_print_csel:0
	mov al, "M"
	mov ah, white
        call lib_putchar_csel:0
	mov al, "B"
        call lib_putchar_csel:0
	and byte [fs:temp_mask], 0fdh		;Free this temp. memory position for use.


	mov ecx, 2
two_crs:
	mov al, 13
	call lib_putchar_csel:0
	mov al, 10
	call lib_putchar_csel:0
	loop two_crs

	mov al, 0
	mov ecx, 4
	mov esi, hd0_numheads
hdcountloop:
	cmp word [esi], 0
	jz hd_dont_count
	inc al
hd_dont_count:
	add esi, 7
	loop hdcountloop

	mov ah, white
	add al, "0"		;Print the # of hard disks found
	call lib_putchar_csel:0

	mov esi, hd_strings
	mov al, white
	call sys_print_csel:0	;Print " Hard disks were found on your computer:"

	mov ax, shared_data_sel
	mov es, ax
	mov edi, hd_strings

	cmp word [es:hd0_numheads], 0	;See if there is a hd here
	jz show_hd1
	mov esi, hd_strings + 41	;next string
	mov al, white
	call sys_print_csel:0		;print "HD"
	mov eax, white * 256 + "0"	;print "0"
	call lib_putchar_csel:0

	xor eax, eax
	xor ecx, ecx
	xor edx, edx
	mov ax, word [es:hd0_numheads]
	mov cx, word [es:hd0_numcylinders]
	mov dx, word [es:hd0_numsectors]
	call shownumber
show_hd1:
	cmp word [es:hd1_numheads], 0
	jz show_hd2
	mov esi, hd_strings + 41
	mov al, white
	call sys_print_csel:0
	mov eax, white * 256 + "1"
	call lib_putchar_csel:0
	mov ax, word [es:hd1_numheads]
	mov cx, word [es:hd1_numcylinders]
	mov dx, word [es:hd1_numsectors]
	call shownumber
show_hd2:
	cmp word [es:hd2_numheads], 0
	jz show_hd3
	mov esi, hd_strings + 41
	mov al, white
	call sys_print_csel:0
	mov eax, white * 256 + "2"
	call lib_putchar_csel:0
	mov ax, word [es:hd2_numheads]
	mov cx, word [es:hd2_numcylinders]
	mov dx, word [es:hd2_numsectors]
	call shownumber
show_hd3:
	cmp word [es:hd3_numheads], 0
        jz hd_backtokernel
	mov esi, hd_strings + 41
	mov al, white
	call sys_print_csel:0
	mov eax, white * 256 + "3"
	call lib_putchar_csel:0
	mov ax, word [es:hd3_numheads]
	mov cx, word [es:hd3_numcylinders]
	mov dx, word [es:hd3_numsectors]
	call shownumber
hd_backtokernel:
	jmp overhdcalls
shownumber:
	push edx
	push ecx
	push eax
	mov esi, hd_strings + 47
	mov al, white
	call sys_print_csel:0
	pop eax
	call lib_bin_dec_csel:0
	mov esi, hd_strings
	mov al, white
	call sys_print_csel:0
	mov esi, hd_strings + 56
	mov al, white
	call sys_print_csel:0
	pop eax
	call lib_bin_dec_csel:0
	mov esi, hd_strings
	mov al, white
	call sys_print_csel:0
	mov esi, hd_strings + 69
	mov al, white
	call sys_print_csel:0
	pop eax
	call lib_bin_dec_csel:0
	mov esi, hd_strings
	mov al, white
	call sys_print_csel:0
	ret
overhdcalls:

	pop es
	pop ds	
	popad
end_display_info: