        push ds

        mov ax, 0
        mov ds, ax
        mov si, 4 * 8
        mov eax, dword [ds:si]
        push eax        ;save offset, segment of int8 (timer)

        hlt             ;halt to make sure an int8 doesn't interrupt this

        mov ax, es
        shl eax, 16     ;get segment of new int8 into high word eax
        mov ax, new_int8        ;get offset of new int8 into low word eax
        mov dword [ds:si], eax

        mov cx, 10      ;test 10 times
test_again:
        push cx
        xor ecx, ecx    ;clear ecx because it will be used as a counter

        hlt             ;hlt so that the code starts right at the beginning
        nop             ;of the timed 1/18.2 of a second
        nop             ;int8 will add 4 to the return offset so that
        nop             ;when it gets called during the count loop, it will
        nop             ;return ahead of that position. Therefore this will
        nop             ;count (2 clock cycles) until 1/18.2 of a second is
countloop:              ;up. At that time we can see how many cycles/second
        inc ecx
        jmp countloop
        nop
        nop
        nop
        nop
        nop

        cmp ecx, dword [es:fastest]
        jbe not_faster
        mov dword [es:fastest], ecx
not_faster:
        pop cx
        loop test_again

        pop eax
        mov dword [ds:si], eax  ;return old offset & segment of int8

        mov ecx, dword [es:fastest]

        pop ax          ;pop old ds
        mov ds, ax      ;return it to normal

        mov [es:hertz], ecx
        fild dword [es:hertz]           ;load # cycles counted
        fmul dword [es:multiplier]      ;multiply by 18.2 b/c lasted 1/18.2s
        fimul word [es:two]             ;multiply by 2 b/c 2 cycles were used each loop
        fistp dword [es:hertz]          ;store final integer result into hertz
                                        ;and pop this value from fpu stack
        mov eax, dword [es:hertz]
	mov dword [shared_data + cpu_speed], eax

	jmp done_clocking


new_int8:
        pop eax
        add eax, 5
        push eax

        mov al, 20h
        out 20h, al
        iret

fastest         dd      0
dec_buffer      db      "0000 Mhz$"
hertz           dd      0
;                                   |  byte4  | byte3  || byte2|| byte1|
multiplier      dd      041919999h ;=0 1000001 1 00100011001100110011001xb
                        ;=positive(0), 10000011=131 (exponent = 4 + biased
                        ;constant 127 (127+4=131)), 00100011... = 18.2
                        ;w/ first bit of it assumed to be 1 (standard integer
                        ;format) and it is shift out to the very left
                        ;4 places (exponent = 4). So 18.2 in binary would be
                        ;10010.0011001100110011001... but not enough sig figs
two             dw      2

done_clocking: