;This code was written specifically for the A86 assembler, although it may
;work with others such as TASM
.MODEL SMALL
.STACK 20H
.CODE

MAIN:
                                   
BOOTSEC: 
        THE_JUMP DB 0EBH, 3CH, 90H
        ;Jump to start of boot sector code
       
DOS_ID:         DB      "FD1", 0, 0, 0, 0, 0 ;Name of this boot sector (8 bytes)
SEC_SIZE: 	DW 	200H 		;Size of a sector, in bytes
SECS_PER_CLUST: DB      1               ;Number of sectors in a cluster
FAT_START:      DW      2               ;Starting sector for the first FAT
FAT_COUNT:      DB      2               ;Number of FATs on this disk
ROOT_ENTRIES:   DW      0               ;Number of root directory entries
SEC_COUNT:      DW      0B04H           ;Total number of sectors on this disk
DISK_ID:        DB      0F0H            ;Disk type code (This is 360KB)
SECS_PER_FAT:   DW      20               ;Number of sectors per FAT
SECS_PER_TRK:   DW      18              ;Sectors per track for this drive
HEADS: 		DW 	2 		;Number of heads (sides) on this drive
HIDDEN_SECS: 	DW 	0 		;Number of hidden sectors on the disk
DSKBASETBL:
		DB 	0 	;Specify byte 1
		DB 	0 	;Specify byte 2
		DB 	0 	;Wait time until motor turned off, in clk ticks
                DB      2       ;Bytes per sector (0=128, 1=256, 2=512, 3=1024)
		DB 	12H 	;Last sector number (lg enough to handle 1.44M)
		DB 	0 	;Gap length between sectors for r/w operations
		DB 	0 	;Data xfer lgth when sector lgth not specified
		DB 	0 	;Gap lgth between sectors for formatting
		DB 	0 	;Value stored in newly formatted sectors
		DB 	1 	;Head settle time, in milliseconds
		DB 	0 	;Motor startup time, in 1/8 seconds
HEAD: 		DB 	0 	;Current head to read from
					;Here is the start of the boot sector code
PRE_DNAME DB "Brian's Disk"
;Dos uses the chars FAT12 here on its floppies so its safe to say that I can use this as an ID
;section for HCPOS partitions also. This is at offset 46.
FILE_SYSTEM DB "HCP1.000"
	;This is what used to be above:
	;PRE_MESSAGE DB "Hello!!!"        ;Many boot disks use a jump to offset 62 for code

BOOT:                      ;so I am too.

        MOV AX, 7B0H
        MOV DS, AX
        MOV ES, AX

        JMP OVERDATA1
MESSAGE1 DB 13, 10, "Welcome to an HCP OS hosted computer!"
MESSAGE2 DB 13, 10, "Choose:",13,10,"1. HCP OS",13,10,"2. Windozzz",0
OVERDATA1:
        MOV BH, 0
        MOV SI, OFFSET MESSAGE1 ;[7C00H + 62 + 4]  ;[OFFSET MESSAGE1 + 7B00H]          ; + 7C00H - 100H
        MOV AH, 0EH
THELOOP:
        LODSB
        INT 10H
               
        CMP BYTE PTR [ES:SI], 0
        JZ TO_OS
        JMP THELOOP

TO_OS:

	XOR AX, AX
	INT 16H
	PUSH AX

        MOV AH, 0		;Reset floppy drive?
        MOV DL, 0
        INT 13H

;        MOV BX, OFFSET BUFFER ;[7C00H + 512]
	POP AX
	CMP AL, "1"
	JZ DO_HCPOS

	XOR AX, AX
	MOV DS, AX
	MOV ES, AX

	MOV DI, 0600H
	MOV SI, OFFSET LOADCODE + 07c00h - 0100h
	MOV CX, OFFSET END_LOADCODE - OFFSET LOADCODE
	REP MOVSB

	JMP 0:0600H

LOADCODE:
        MOV BX, 07C00H

;this code below loads 10 sectors (5120 bytes) from the floppy after the fat
;to mem at 7d0h
        MOV AH, 02H  ;byte offset = 77 * 512 = 39424
        MOV AL, 1    ;sector = int[(39424/512) + 1] mod 9 = 6 : CL = 6   
        MOV CH, 0    ;track = int[(39424/512) / 9] = 8        
        MOV CL, 1    ;head = track mod 2 = 8 mod 2 = 0        : DH = 0    
        MOV DX, 128  ;cylinder = fix(8 / 4) = 2               : CH = 2 & CL bits 7,6 = 0,0 
                     ;DX = 0  b/c  DL = 0 (floppy) & Head = 0
        INT 13H

	JMP 0:07C00H
END_LOADCODE:	

DO_HCPOS:
        MOV AX, 7E0H
        MOV DS, AX
        MOV ES, AX

        MOV BX, 0

;this code below loads 10 sectors (5120 bytes) from the floppy after the fat
;to mem at 7E0h
;        MOV AH, 02H  ;byte offset = 77 * 512 = 39424
;        MOV AL, 13   ;sector = int[(39424/512) + 1] mod 9 = 6 : CL = 6   
;        MOV CH, 2    ;track = int[(39424/512) / 9] = 8        
;        MOV CL, 6    ;head = track mod 2 = 8 mod 2 = 0        : DH = 0    
;        MOV DX, 0    ;cylinder = fix(8 / 4) = 2               : CH = 2 & CL bits 7,6 = 0,0 
                     ;DX = 0  b/c  DL = 0 (floppy) & Head = 0
	MOV AX, 020DH	;13 SECTORS
	MOV CX, 0106H
	XOR DX, DX
        INT 13H

	MOV CX, 4
OUTLOOP:
	PUSH CX
	XOR CX, CX
INLOOP:	LOOP INLOOP
	POP CX
	LOOP OUTLOOP

        MOV BX, 6656
;        MOV BX, OFFSET BUFFER + 6656    ;6656=13 sectors * 512 bytes each
                        ;Remember, 12 sectors have already been loaded before
                        ;this.
;        MOV AH, 02H     ;Everything is similar this time, except it can read
;        MOV AL, 18      ;18 sectors b/c it is at the beginning of a track and
;        MOV CH, 2
;        MOV CL, 1       ;Start at sector 1 of this track
;        MOV DX, 0100H   ;DH=1 b/c it is at head 1 this time instead of head 0
	MOV AX, 0212H
	MOV CX, 0101H
	MOV DX, 0100H
        INT 13H

        JMP BUFFER

THE_STACK_SPACE DB 100 DUP (?)
STACK_POINTER:
                     ;Precompiled this was 153 bytes, need 512 so I added
                     ;this 357 byte dup & the boot signature bytes
SOME_SPACE DB 76 DUP (?)
	PARITION_ACTIVE		DB	80H
	FIRST_HEAD		DB	0
	FIRST_SECTOR		DB	2	;Actually bits5-0 are sector#, bits7&6 are high 2bits cylinder#
	FIRST_CYLINDER		DB	0	;Low eight bits cylinder #
        FILE_SYS                DB      080H   ;HCP partition ID (check inc\equates.asm to make sure this is still 100h)
	LAST_HEAD		DB	1	;Floppies have 2 heads 0&1
	LAST_SECTOR		DB	18	;Floppies have 18 sectors/track
	LAST_CYLINDER		DB	79	;Floppies have 80 cylinders 0-79
		;It ends on the last cylinder, head and sector of this floppy...
	START_LBA		DD	2	;Start at sector 2
	LENGTH_LBA		DD	2880	;2880 Sectors on a floppy disk
REST_PRT_TBL	DB 48 DUP (?)
SIGNATURE  DB 55H, 0AAH
BUFFER:
END MAIN
