;This code was written in NASM because I needed an Assembler that supports
;almost all 32-bit instructions and now it has become my FAVORITE assembler.
;WARNING: Maximum size of OS.com before some of the gdt offsets begin to be messed up is about 33279 bytes
[bits 16]

%include "inc\equates.asm"

start_code:
	mov ecx, 80000h
firstwait:	
	db 067h		;make it a 32-bit loop (ecx)
	loop firstwait

	mov ax, 0e0ah	;For some reason my CPU clocking routine is about 20MHZ fast if I don't have either a print char
	int 10h		;BIOS call or a getchar BIOS call here... Other calls might have the same positive affect on this,
			;but I discovered this on accident - I really have no idea why it doesn't work with these here.
			;And if there is a problem with my routine, why would these help to make it work almost exactly
			;right??? - It's a mystery.
	mov ah, 2
	mov al, 5
	mov cx, 1
	mov dx, 128
	mov bx, gdt_end
	int 13h

        mov al, 0ch     ;00001100xb=set motors for floppy drives D->A not on,DMA&I/O enable,FloppyController enable, select
                        ;floppy drive 00
        mov dx, 03f2h   ;purpose of this command is to shut off floppy motor
        out dx, al

	finit	;initialize the fpu (also masks all fpu exceptions, sets precision 64-bits, (fpu control word = 37fh))

	%include "init\cpuclock.asm"
	%include "init\BIOSData.asm"
        %include "init\PMswitch.asm"
        jmp sys_code_sel:0
[bits 32]
code32:
	mov ax, sys_data_sel
	mov ds, ax
        mov gs, ax

        mov ax, shared_data_sel
        mov fs, ax

        mov ax, linear_data_sel
        mov es, ax

	mov ax, stack_sel
	mov ss, ax
	mov ebp, stack_end - the_stack
	mov esp, ebp

%include "init\Hrdwrcfg.asm"
        sti
	;NOTE: Leave this sti before the inits!
%include "init\inits.asm"	;initiaze # loop opcodes needed per 1/millionth of a sec delay in delay syscall
                                ;requires: fs->shared_data
%include "init\dispinfo.asm"

	mov ax, 0e6h
	mov cx, 2
	mov bl, 1
	call sys_fd_rw_csel:0

	mov ax, 0e5h	;ah=0=bit2: head 0, bits1-0: floppy drive 0; and al=11100110xb=multi-track, MFM encoding,
			;skip deleted data address mark, bits4->0 have to be 00110xb if read, 00101xb if write!!!!!
	mov cx, 2	;cl=#sectors, ch=cylinder #
	mov bl, 1	;bl=sector #
	call sys_fd_rw_csel:0

	mov eax, 070dh			;print a line feed with a white attribute
        call lib_putchar_csel:0
	mov eax, 070ah			;carriage return with a white attribute
        call lib_putchar_csel:0

	mov cx, 0302h		;head3, 2 sectors
	mov ax, 1		;cylinder 1
	mov bx, 2		;starting at sector 2
	mov edi, 0
	call sys_hdread_csel:0

			;in:	ecx = # bytes desired
			;	ah  bit 7 = 0
			;	    bit 6 = 32-bit if set 
			;	    bit 5 = 0
			;	    bit 4 = LDT if set, GDT if clear
			;	    bit 3 = 1 if a twin segment is to be made. (MAKE SURE TO SEE MEMMGR.txt to get this right!!!)
			;	    bit 2 = IF a twin segment is being made this is the conforming bit. Else, set to 0.
			;	    bits 1-0 = 0
			;	al  bit 7 = 0
			;	    bits 6-5 = Requested Privelege Level (RPL)
			;	    bits 4-3: 10=regular data seg, 11=executable seg, 01=system seg (TSS, etc.)
			;	    bit 2 = if set: expandable downward if data, conforming if executable
			;	    bits 1 = if set: writable if data, readable if code
			;	    bit 0 = 0
;This is an example of how to allocate 1MB of twin memory and then deallocate it

	push es
	mov eax, 04812h
	mov ecx, 0100000h
	call sys_alloc_mem_csel:0
	mov es, dx
	mov word [ds:newcodecs], ax
	mov byte [es:0], 203		;Put a retf opcode into the segment and then jump to that segment
	call far [ds:newcode]
	pop es

	call sys_dealloc_mem_csel:0
	mov eax, edx
	call sys_dealloc_mem_csel:0

	push ds
	mov ax, shared_data_sel
	mov ds, ax
	mov esi, test_mount
	call sys_mount_dev_csel:0
	pop ds

        mov byte [fs:screen_attribute], blue
print_screen:
	call lib_getchar_csel:0
	mov ah, byte [fs:screen_attribute]
another_char:
	call lib_putchar_csel:0
	cmp al, 13
	jne not_cr
	mov al, 10
	jmp another_char
not_cr:
	jmp print_screen

;********** I N T E R R U P T   H A N D L E R S ************
        %include "inc\handlers.asm"
;************** S Y S T E M   C A L L S ***************
	%include "api\TxtVideo.asm"
	%include "api\Storage.asm"
	%include "api\MemMgr.asm"
        %include "api\SYSCalls.asm"
	%include "api\FileSys.asm"
	%include "api\Network.asm"
	%include "api\Users.asm"
;************* L I B R A R Y   C A L L S **************
        %include "api\LIBCalls.asm"

;**************************** S T A C K ******************************
align 8
the_stack:      TIMES    stack_size   db   0
stack_end:

shared_data:
%include "inc\shared.asm"
end_shared_data:

;********************** Interrupt Descriptor Table ***********************
align 8
idtr:   dw      idt_end - idt_start - 1
        dd      idt_start + original_offset

%include "inc\IDT.asm"
idt_end:

;******************* Exception & Real mode D A T A ********************
message1        db      "PROTECTED MODE!"
                TIMES 150 db 0
                db      "Welcome!",0
exc6            db      "Invalid opcode"
excA            db      "invalid TSS   "
excD            db      "Gen protection"
unknown         db      "Unknown Error "

newcode		equ 	$ - code32
		dd	0
newcodecs	equ	$ - code32
		dd	0
;************************ Global Descriptor Table ***********************
align 8
gdtr:	dw	0ffffh;gdt_end - gdt_start - 1
        dd      gdt_start + original_offset

%include "inc\GDT.asm"
