;******************* PRINT SYSTEM CALL ******************
print:			;This subroutine takes ds:esi -> asciiz message, & al = attribute & prints to screen @ current
			;ycoord & xcoord in shared data segment. All registers are returned unchanged.
	pushad
	pushfd
	push es
	push fs
	push ax
	cld
	mov ax, shared_data_sel
	mov fs, ax
	mov eax, dword [fs:mode_type]
	cmp eax, "text"
	jz not_print_err1       ;not a text mode... *** Soon replace w/ a graphics routine ***
	jmp print_err1

not_print_err1:
	mov ecx, dword [fs:ycoord]
	inc ecx                 ;See below for same reason (inc ebx)
	cmp ecx, dword [fs:screen_height]
	jna not_print_cls
	call sys_cls_csel:0

not_print_cls:
	dec ecx                 ;The inc was only needed for comparison
	xor eax, eax
	or ecx, 0
	jz print_ycoordzero
find_character_position:
	add eax, dword [fs:screen_width]
	loop find_character_position
print_ycoordzero:
	mov ebx, dword [fs:xcoord]
	inc ebx         ;because starts at x=0, we must inc this so we can
                        ;compare it to the screen_width b/c if screen is 80x25
                        ;we want to compare 80, 80 not 79, 80. If not, we will
                        ;increment the xcoord past 79 (actually the 80th column)
	cmp ebx, dword [fs:screen_width]
	jna print_not_too_wide      ;Error if xcoord exceeds screen width
	
	inc dword [fs:ycoord]		;If location requested had xcoord > screen_width, adjust by just putting it on the
	mov dword [fs:xcoord], 0	;next line.
	jmp not_print_err1		;Go back and make sure this new ycoord isn't off screen. Also, edi will be calculated
					;with these new numbers only.
	        
print_not_too_wide:
	dec ebx         ;Was only needed for comparison
	add eax, ebx

	mov edi, dword [fs:video_offset]
	shl eax, 1			;Account for attribute bytes...
	add edi, eax
	mov ax, linear_data_sel
	mov es, ax

	pop ax				;al was saved for attribute
printing_loop:
	or byte [ds:esi], 0		;If null byte, string terminated, done
	jnz not_done_printing
	jmp done_printing
not_done_printing:
	cmp byte [ds:esi], 13		;Check for enter key
	jz print_carriage_return
	cmp byte [ds:esi], 09		;Check for tab
	jz print_tab
	cmp byte [ds:esi], 10		;check for line feed
	jnz print_not_lf

	;this is the line feed code:
	inc esi
	mov ebx, dword [fs:xcoord]	;save old xcoord to alter edi correctly
	mov dword [fs:xcoord], 0	;now clear xcoord
	shl ebx, 1			;x2 to account for attribute bytes
	sub edi, ebx			;decrement the cursor to account for returning to the beginning of the line
	jmp printing_loop

print_not_lf:
	movsb				;Do the job
	stosb				;Write attribute
	inc dword [fs:xcoord]

	mov ebx, dword [fs:xcoord]
	cmp ebx, dword [fs:screen_width]
	jna printing_loop		;must see if too big coord now b/c it doesn't check at beginning of printing_loop
	mov dword [fs:xcoord], 0	;don't need to inc coord before checking because it already inc [fs:xcoord]
	inc dword [fs:ycoord]
	push ax
	jmp not_print_err1

	jmp printing_loop

print_carriage_return:
        inc esi			;add 1 to esi to advance it a char, edi isn't advanced b/c carriage return doesn't need
				;to be written, it just needs to be done
	inc dword [fs:ycoord]
	push ax			;resave attribute byte b/c eax will be used for something else and right before
				;printing_loop it will try to pop this, so we don't want to screw up stack...
	jmp not_print_err1	;If jump to here, it analyzes xcoord and ycoord and places appropriately
print_tab:
	mov ecx, dword [fs:screen_width]
	sub ecx, dword [fs:xcoord]
	cmp ecx, dword [fs:tab_length]
	jg print_continue_tab

	inc dword [fs:ycoord]		;If there isn't enough room on current row to tab, just move to next line.
	mov dword [fs:xcoord], 0
	push ax				;remember to repush attribute before jumping to not_print_err1
	inc esi
	jmp not_print_err1
print_continue_tab:
	mov ecx, dword [fs:tab_length]
	add dword [fs:xcoord], ecx
print_tabbing:
	mov byte [es:edi], " "
	add edi, 2
	loop print_tabbing
	push ax
	inc esi
	jmp not_print_err1
	
done_printing:
	pop fs
	pop es
	popfd
	popad
	clc
        retf
end_print:

print_err1:
	pop ax
	pop fs
	pop es
	popfd
	popad
	mov ax, 1		;Non-text mode error code = 1
	stc
        retf
print_err3:			;Too many characters for current screen, recommended: wait for a user key, cls, recall print
	pop fs
	pop es
	popfd
	popad
	mov ax, 3
	stc
	retf

;************** END OF PRINT SYSTEM CALL *****************






;********************************* AND NOW THE OLD PUTCHAR ROUTINE *******************************
;******************************** Print a Single Character to the Screen ******************
putchar:			;in: char in al, attribute in ah
	push eax		;out: char to next spot on screen & cursor adjusted
	push edi
	push es
	push fs
	push eax		;save char

        mov ax, shared_data_sel
        mov fs, ax
	mov ax, linear_data_sel
	mov es, ax

	mov eax, dword [fs:mode_type]
	cmp eax, "text"
        jz not_putchar_err1       ;not a text mode... *** Soon replace w/ a graphics routine ***
        jmp putchar_err1
not_putchar_err1:			;If it got here it's a text mode
	pop eax
	cmp al, 13
        jz putchar_cr
	cmp al, 10
        jnz putchar_notbeginningline
        jmp putchar_beginningline
putchar_notbeginningline:
	cmp al, 8
        jnz putchar_notbackspace
        jmp putchar_backspace
putchar_notbackspace:
	cmp al, 9
        jnz putchar_normal
        jmp putchar_tab

putchar_normal:
	mov edi, dword [fs:video_offset]
	push eax
	mov eax, dword [fs:screen_width]
	mul dword [fs:ycoord]
	add eax, dword [fs:xcoord]
	shl eax, 1			;multiply by 2 to account for the attribute bytes
	add edi, eax
	pop eax
	mov byte [es:edi], al
	mov byte [es:edi + 1], ah

	inc dword [fs:xcoord]
	mov eax, dword [fs:xcoord]
	cmp eax, dword [fs:screen_width]
        jae putchar_advancey
        jmp putchar_done

putchar_cr:
	mov eax, dword [fs:ycoord]
	inc eax
	cmp eax, dword [fs:screen_height]
        jb putchar_onlyadvancey              ;If it isn't at very end of screen advance the ycoord
        jmp putchar_cls                      ;If it is, clear the screen
putchar_onlyadvancey:
	inc dword [fs:ycoord]
        jmp putchar_done

putchar_advancey:
	inc dword [fs:ycoord]
	mov eax, dword [fs:ycoord]
	cmp eax, dword [fs:screen_height]
        jae putchar_cls
putchar_beginningline:
	mov dword [fs:xcoord], 0
        jmp putchar_done

putchar_backspace:
	push eax			;going to need attribute again
	cmp dword [fs:xcoord], 0
        jz putchar_notnormalbackspace
	dec dword [fs:xcoord]
        jmp putchar_finishbackspace          ;skip over the stuff to move the ycoord back 1 and xcoord to the end
putchar_notnormalbackspace:
	cmp dword [fs:ycoord], 0
        jz putchar_finishbackspace   ;x and y are 0 so leave them alone and overwrite anything at 0,0 on screen

	mov eax, dword [fs:screen_width]	;decrement ycoord and put xcoord at end of line.
	dec eax
	mov dword [fs:xcoord], eax
	dec dword [fs:ycoord]
putchar_finishbackspace:
	pop eax
	mov al, " "			;This will just overwrite the last char with a " " and the intended attribute
        jmp putchar_normal           ;Now that we are back a position, print the space over the last char

putchar_tab:
	mov ecx, [fs:tab_length]
	mov al, " "
putchar_tab_loop:
        call lib_putchar_csel:0      ;call itself 5 times with " " and given attribute
        loop putchar_tab_loop
        jmp putchar_done

putchar_cls:
	call sys_cls_csel:0

putchar_done:
	call sys_cursor_csel:0
	pop fs
	pop es
	pop edi
	pop eax
	clc
	retf

putchar_err1:
	pop fs
	pop es
	pop edi
	pop eax
	stc
	mov al, 1
	retf
end_putchar:
