        mov eax, dword [fs:ycoord]
        mul dword [fs:screen_width]
        add eax, dword [fs:xcoord]
        shl eax, 1              ;account for attribute bytes
        mov edi, eax
        add edi, dword [fs:video_offset]
theloop_withcursor:
	call sys_cursor_csel:0
theloop:
        cmp byte [fs:numkeys], 0
        jz theloop
        mov esi, shared_data - code32 + keybuffer
        add si, word [fs:keyptr]
;Now that we have the location in mem, adjust pointers to account for
;removing the key from the buffer.
        cmp word [fs:keyptr], 24        ;See if at end of buffer space
        jae need_to_wrap_around
        inc word [fs:keyptr]
        jmp dont_wrap_around
need_to_wrap_around:
        mov word [fs:keyptr], 0
dont_wrap_around:
        dec byte [fs:numkeys]

	cmp byte [esi], 13	;see if enter
	jz nextline
	cmp byte [esi], 8	;See if backspace
	jz backspace
	cmp byte [esi], 9	;See if tab
	jnz not_tab
	jmp tab
not_tab:
        movsb
        mov al, blue
        stosb

	inc dword [fs:xcoord]
	mov eax, dword [fs:xcoord]
        inc eax                 ;line #'s start at 0 instead of 1, so 0-79 not 1-80
        cmp eax, dword [fs:screen_width]
	jna theloop_withcursor		;If it hasn't passed the end of the x coord, loop
nextline:				;This will inc ycoord and cls if off screen or continue by fixing xcoord if not off screen
	mov eax, dword [fs:ycoord]
        inc eax
	inc eax				;Must increment twice b/c the ycoord hasn't been incremented yet & we have to inc 1
	cmp eax, [fs:screen_height]	;past what we want it to be when we're done (b/c lines go 0-24 not 1-25...)
	jna continue_nextline
	call sys_cls_csel:0
	mov edi, dword [fs:video_offset]
	jmp theloop_withcursor
continue_nextline:			;This moves xcoord to beginning of next line (continued from nextline)
	mov eax, dword [fs:xcoord]
	shl eax, 1
	sub edi, eax			;pointer is going from spot x to the beginning of the line, down a line...
	mov eax, dword [fs:screen_width]
	shl eax, 1
	add edi, eax			;So adjust edi accordingly
	mov dword [fs:xcoord], 0
	inc dword [fs:ycoord]
        jmp theloop_withcursor

backspace:
	cmp dword [fs:xcoord], 0
	je lastline
	sub edi, 2	;decrement the video pointer by four ((char & attribute) * 2) because we have to go back AND it has
			;already been advanced a position
	mov byte [es:edi], " "	;replace last char with a space
	dec dword [fs:xcoord]
	jmp theloop_withcursor
lastline:			;This is called if a backspace is used at the beginning of line (this will move it up a line)
	cmp dword [fs:ycoord], 0
	jz at_the_beginning
	sub edi, 2	;decrement the video pointer by 2 (char & attribute) because we have to go back
	mov byte [es:edi], " "	;replace last char with a space
	mov eax, dword [fs:screen_width]
	dec eax
	mov dword [fs:xcoord], eax
	dec dword [fs:ycoord]
	jmp theloop_withcursor

at_the_beginning:		;This is if a backspace was typed while at the very top left of screen
	mov dword [fs:ycoord], 0
	mov dword [fs:xcoord], 0
	jmp theloop_withcursor	

tab:
	mov ecx, dword [fs:screen_width]
	sub ecx, dword [fs:xcoord]
	cmp ecx, dword [fs:tab_length]
	jg continue_tab
	jmp nextline
continue_tab:
	mov ecx, [fs:tab_length]
	add dword [fs:xcoord], ecx
tabbing:
	mov byte [es:edi], " "
	add edi, 2
	loop tabbing
	jmp theloop_withcursor