	mov al, 0adh
	out 64h, al	;disable keyboard for now...

	in al, 64h
	test al, 1
	jnz do_nothing	;The output buffer is still full, so exit writeLEDs (This FAILED)

	mov al, 020h
	out 64h, al	;Command to have it send the command byte to 60h (bit0 tells if keyboard int enabled, the others
			;need to be restored after we disable int9 and then enable int9) (more info in keyboard.txt)
	call wait_time
	in al, 60h
	push ax		;save the command byte so it can be restored later
	and al, 0feh	;clear bit0
	push ax		;save the new command byte until after command to write it is issued
	call wait_time
	mov al, 60h
	out 64h, al	;command to write to command byte via port 60h
	call wait_time
	pop ax		;write command has been issued, get the new command byte
	out 60h, al
	call wait_time
request_resend:
	mov al, 0edh	;command to write LEDs via port 60h
	out 60h, al
	call wait_time
	in al, 60h	;read acknowledge/request resend byte
	cmp al, 0feh
	call wait_time
	jz request_resend	;controller requests that the command is resent...
	cmp al, 0fah
	jnz restore_command_byte	;If it doesn't return an acknowledge byte, end with a FAILURE

	mov al, byte [fs:togglekeys]
	and al, 7	;7=00000111xb (bits2-0 are caps, num, scroll, respectively)
	out 60h, al	;write key state

restore_command_byte:	
	call wait_time
	mov al, 60h
	out 64h, al	;command to write command byte via port 60h
	call wait_time
	pop ax		;get old command byte
	out 60h, al	;write the old command byte back (this will restart int9 again)

	mov al, 0aeh
	out 64h, al

	ret

wait_time:
	mov ecx, 0fffffh
wait_time_loop: loop wait_time_loop
	ret